/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.ScaffolderResource;
import org.mule.tools.apikit.model.ScaffoldingError;
import org.mule.tools.apikit.model.ScaffoldingResult;

public final class ScaffolderResult
implements ScaffoldingResult {
    private final List<MuleConfig> generatedConfigs;
    private final List<ScaffolderResource> generatedResources;
    private final List<ScaffoldingError> errors;

    private ScaffolderResult(List<MuleConfig> generatedConfigs, List<ScaffolderResource> generatedResources, List<ScaffoldingError> errors) {
        this.generatedConfigs = generatedConfigs;
        this.generatedResources = generatedResources;
        this.errors = errors;
    }

    @Override
    public boolean isSuccess() {
        return this.errors.isEmpty();
    }

    @Override
    public List<MuleConfig> getGeneratedConfigs() {
        return Collections.unmodifiableList(this.generatedConfigs);
    }

    @Override
    public List<ScaffolderResource> getGeneratedResources() {
        return Collections.unmodifiableList(this.generatedResources);
    }

    @Override
    public List<ScaffoldingError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<MuleConfig> generatedConfigs = new ArrayList<MuleConfig>();
        private List<ScaffolderResource> generatedResources = new ArrayList<ScaffolderResource>();
        private List<ScaffoldingError> errors = new ArrayList<ScaffoldingError>();

        public Builder withGeneratedConfigs(List<MuleConfig> configs) {
            this.generatedConfigs = configs;
            return this;
        }

        public Builder withGeneratedResources(List<ScaffolderResource> resources) {
            this.generatedResources = resources;
            return this;
        }

        public Builder withErrors(List<ScaffoldingError> errors) {
            this.errors = errors;
            return this;
        }

        public ScaffolderResult build() {
            return new ScaffolderResult(this.generatedConfigs, this.generatedResources, this.errors);
        }
    }
}

