/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.apache.commons.lang3.Validate;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;

public class ResourceActionMimeTypeTriplet {
    private final ApikitMainFlowContainer api;
    private final String uri;
    private final String verb;
    private final String mimeType;

    public ResourceActionMimeTypeTriplet(ApikitMainFlowContainer api, String uri, String verb) {
        this(api, uri, verb, null);
    }

    public ResourceActionMimeTypeTriplet(ApikitMainFlowContainer api, String uri, String verb, String mimeType) {
        Validate.notNull((Object)api);
        Validate.notNull((Object)uri);
        Validate.notNull((Object)verb);
        this.uri = uri;
        this.verb = verb.toUpperCase();
        this.api = api;
        this.mimeType = mimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceActionMimeTypeTriplet that = (ResourceActionMimeTypeTriplet)o;
        if (!this.api.equals(that.api)) {
            return false;
        }
        if (!this.uri.equals(that.uri)) {
            return false;
        }
        if (!this.verb.equals(that.verb)) {
            return false;
        }
        return this.mimeType == null || this.mimeType.equals(that.mimeType);
    }

    public String toString() {
        return "ResourceActionMimeTypeTriplet{uri='" + this.uri + '\'' + ", verb='" + this.verb + '\'' + ", mimeType='" + this.mimeType + '\'' + '}';
    }

    public int hashCode() {
        int result = this.api.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + this.verb.hashCode();
        if (this.mimeType != null) {
            result = 31 * result + this.mimeType.hashCode();
        }
        return result;
    }

    public ApikitMainFlowContainer getApi() {
        return this.api;
    }

    public String getUri() {
        return this.uri;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

