/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.tools.apikit.misc.DataWeaveExpressionUtils;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class HttpRequestScope
implements Scope {
    private String uri;
    private String mimeType;
    private String statusCode;
    private GenerationModel flowEntry;

    public HttpRequestScope(GenerationModel flowEntry, String uri, String mimeType, String statusCode) {
        this.uri = uri;
        this.mimeType = mimeType;
        this.statusCode = statusCode;
        this.flowEntry = flowEntry;
    }

    @Override
    public Element generate() {
        Element element = new Element("request", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        element.setAttribute("config-ref", "HTTP_Request_Configuration");
        element.setAttribute("method", this.flowEntry.getVerb());
        element.setAttribute("path", this.uri);
        this.addHttpRequestParameters(element, this.flowEntry, this.mimeType);
        this.addSuccessStatusCodeValidator(element, this.statusCode);
        return element;
    }

    private void addHttpRequestParameters(Element requester, GenerationModel flowEntry, String mimeType) {
        this.addHttpRequestHeaders(requester, flowEntry, mimeType);
        this.addHttpRequestQueryParameters(requester, flowEntry);
    }

    private void addHttpRequestHeaders(Element request, GenerationModel flowEntry, String mimeType) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.addAcceptHttpRequestHeaderParameter(headers, mimeType);
            this.addContentTypeHttpRequestHeaderParameter(headers, flowEntry.getVerb(), flowEntry.getMimeType());
            this.addHeaders(headers, flowEntry);
            if (!headers.isEmpty()) {
                Element element = new Element("headers", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
                element.addContent(DataWeaveExpressionUtils.wrapInExpression(new ObjectMapper().disableDefaultTyping().writeValueAsString(headers)));
                request.addContent((Content)element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAcceptHttpRequestHeaderParameter(Map<String, String> headers, String mimeType) {
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            this.addHttpRequestHeaderParameter(headers, "Accept", mimeType);
        }
    }

    private void addContentTypeHttpRequestHeaderParameter(Map<String, String> headers, String verb, String mimeType) {
        if (("POST".equals(verb) || "PUT".equals(verb) || "PATCH".equals(verb)) && StringUtils.isNotBlank((CharSequence)mimeType)) {
            this.addHttpRequestHeaderParameter(headers, "Content-Type", mimeType);
        }
    }

    private void addHeaders(Map<String, String> headers, GenerationModel flowEntry) {
        flowEntry.getAction().getHeaders().entrySet().stream().filter(header -> ((Parameter)header.getValue()).isRequired()).forEach(header -> {
            String exampleValue = ((Parameter)header.getValue()).getExample();
            String defaultValue = ((Parameter)header.getValue()).getDefaultValue();
            String value = exampleValue != null ? exampleValue : (defaultValue != null ? defaultValue : "");
            this.addHttpRequestHeaderParameter(headers, (String)header.getKey(), value);
        });
    }

    private void addHttpRequestHeaderParameter(Map<String, String> headers, String header, String value) {
        if (StringUtils.isNotBlank((CharSequence)header)) {
            headers.put(header, value);
        }
    }

    private void addSuccessStatusCodeValidator(Element requester, String statusCode) {
        Element responseValidatorElement = new Element("response-validator", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        Element successCodeElement = new Element("success-status-code-validator", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        successCodeElement.setAttribute("values", statusCode);
        responseValidatorElement.addContent((Content)successCodeElement);
        if (StringUtils.isNotBlank((CharSequence)statusCode) && Integer.valueOf(statusCode) >= 400) {
            requester.addContent((Content)responseValidatorElement);
        }
    }

    private Boolean addHttpRequestQueryParameters(Element request, GenerationModel flowEntry) {
        try {
            Map queryParameters = flowEntry.getAction().getQueryParameters();
            Element element = new Element("query-params", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            if (null != queryParameters && !queryParameters.isEmpty()) {
                Map<String, Object> queryParams = queryParameters.entrySet().stream().filter(queryParam -> ((Parameter)queryParam.getValue()).isRequired()).collect(Collectors.toMap(Map.Entry::getKey, this::getQueryParameterValue));
                element.addContent(DataWeaveExpressionUtils.wrapInExpression(new ObjectMapper().disableDefaultTyping().writeValueAsString(queryParams)));
                request.addContent((Content)element);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Object getQueryParameterValue(Map.Entry<String, Parameter> queryParameter) {
        String value;
        String exampleValue = this.getParameterExampleValue(queryParameter.getValue());
        String defaultValue = queryParameter.getValue().getDefaultValue();
        String string = value = exampleValue != null ? exampleValue : defaultValue;
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value.trim();
    }

    private String getParameterExampleValue(Parameter parameter) {
        String example = parameter.getExample();
        if (StringUtils.isBlank((CharSequence)example) && !parameter.getExamples().isEmpty()) {
            example = (String)parameter.getExamples().values().iterator().next();
        }
        return example;
    }
}

