/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.jdom2.Document;
import org.mule.apikit.ScaffoldingConfig;
import org.mule.apikit.odata.utils.ODataXmlHandler;
import org.mule.apikit.xml.XmlHandler;

public class ScaffoldingConfigImpl implements ScaffoldingConfig {

  private final File api;

  private final Map<String, String> customConfigs;

  private final XmlHandler xmlHandler;

  public ScaffoldingConfigImpl(File api, Map<String, InputStream> inputFiles, Map<String, String> customConfigs) {
    this.api = api;
    this.customConfigs = customConfigs;
    this.xmlHandler = new ODataXmlHandler(inputFiles);
  }

  @Override
  public File api() {
    return api;
  }

  @Override
  public Map<String, Document> existingXmls() {
    return xmlHandler.getInputFiles();
  }

  @Override
  public Map<String, String> customConfigs() {
    return customConfigs;
  }

  @Override
  public XmlHandler getXmlHandler() {
    return xmlHandler;
  }

}
