/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata.model;

import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Processor;

public class EntityCollectionListener
extends Processor {
    private static final Namespace odataNamespace = Namespace.getNamespace((String)"apikit-odata", (String)"http://www.mulesoft.org/schema/mule/apikit-odata");
    private static final XPathExpression<Element> entityCollectionListenerExpression = XPathFactory.instance().compile("//*/*[local-name()='request-entity-collection-listener']", Filters.element((Namespace)odataNamespace));

    public EntityCollectionListener(Configuration configuration) {
        super("request-entity-collection-listener", configuration);
    }

    @Override
    public void transformToXml(Element element) {
        Element entityCollectionListener = new Element(this.name, odataNamespace);
        entityCollectionListener.setAttribute("config-ref", this.configuration.getName());
        this.parameters.entrySet().forEach(entry -> entityCollectionListener.setAttribute((String)entry.getKey(), (String)entry.getValue()));
        element.addContent((Content)entityCollectionListener);
    }

    @Override
    public boolean exists(Document document) {
        List elementList = entityCollectionListenerExpression.evaluate((Object)document);
        for (Element element : elementList) {
            String configRef = element.getAttribute("config-ref").getValue();
            String path = element.getAttribute("path").getValue();
            String method = element.getAttribute("method").getValue();
            if (!this.getConfiguration().getName().equals(configRef) || !((String)this.parameters.get("path")).equals(path) || !((String)this.parameters.get("method")).equals(method)) continue;
            return true;
        }
        return false;
    }
}

