/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.mule.apikit.model.MuleXml;

public abstract class XmlHandler {
    protected final Map<String, Document> inputFiles;

    public XmlHandler(Map<String, InputStream> muleXml) {
        this.inputFiles = this.fromInputStreams(muleXml);
    }

    public Map<String, Document> getInputFiles() {
        return this.inputFiles;
    }

    private Map<String, Document> fromInputStreams(Map<String, InputStream> muleXml) {
        SAXBuilder saxBuilder = XmlHandler.getSaxBuilder();
        HashMap<String, Document> result = new HashMap<String, Document>();
        muleXml.entrySet().forEach(entry -> {
            try {
                result.put((String)entry.getKey(), saxBuilder.build((InputStream)entry.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading input files");
            }
        });
        return result;
    }

    public abstract Map<String, InputStream> appendDiff(List<MuleXml> var1);

    protected abstract Map<String, Namespace> getNamespaces();

    protected Element createMuleXml() {
        Element mule = new Element("mule");
        mule.setNamespace(Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core"));
        mule.addNamespaceDeclaration(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Map<String, Namespace> namespaces = this.getNamespaces();
        namespaces.entrySet().forEach(entry -> mule.addNamespaceDeclaration((Namespace)entry.getValue()));
        mule.setAttribute("schemaLocation", this.buildSchemaLocation(namespaces), Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        return mule;
    }

    protected InputStream muleElementToInputStream(Element element) {
        if (element.getDocument() != null) {
            return new ByteArrayInputStream(new XMLOutputter(Format.getPrettyFormat()).outputString(element.getDocument()).getBytes());
        }
        Document output = new Document();
        output.setRootElement(element);
        return new ByteArrayInputStream(new XMLOutputter(Format.getPrettyFormat()).outputString(output).getBytes());
    }

    private String buildSchemaLocation(Map<String, Namespace> namespaces) {
        StringBuilder stringBuilder = new StringBuilder();
        namespaces.entrySet().forEach(entry -> {
            stringBuilder.append(((Namespace)entry.getValue()).getURI());
            stringBuilder.append(" ");
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append(" ");
        });
        return stringBuilder.toString();
    }

    private static SAXBuilder getSaxBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }
}

