/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.internal;

import static java.util.Collections.emptyList;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.mule.apikit.ModelMapper;
import org.mule.apikit.Scaffolder;
import org.mule.apikit.ScaffoldingConfig;
import org.mule.apikit.ScaffoldingResult;
import org.mule.apikit.ScaffoldingResultImpl;
import org.mule.apikit.model.MuleApp;
import org.mule.apikit.model.MuleXml;

public class ODataScaffolder implements Scaffolder {

  protected final ModelMapper apiSpecToModel;

  public ODataScaffolder(ModelMapper apiSpecToModel) {
    this.apiSpecToModel = apiSpecToModel;
  }

  /**
   * Calculate the diff between input XMLs, and generated by modelMapper
   */
  public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {

    MuleApp muleApp = new MuleApp(scaffoldingConfig.existingXmls());

    List<MuleXml> listOfFiles = apiSpecToModel.getModel(scaffoldingConfig.api(), scaffoldingConfig.customConfigs());

    listOfFiles.forEach(
                        file -> {
                          file.getConfigurations().forEach(config -> {
                            if (!muleApp.containsConfig(config)) {
                              muleApp.addConfig(file.getName(), config);
                            }
                          });

                          file.getFlows().forEach(flow -> {
                            if (!muleApp.containsFlow(flow)) {
                              muleApp.addFlow(file.getName(), flow);
                            }
                          });
                        });

    Map<String, InputStream> result = scaffoldingConfig.getXmlHandler().appendDiff(muleApp.getXmls());

    return new ScaffoldingResultImpl(true, result, emptyList());
  }

}
