/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import org.jdom2.Document;

public class MuleApp {

  private final Map<String, Document> muleXmls;

  private final Map<String, MuleXml> diffs = new HashMap<>();

  public MuleApp(Map<String, Document> existingXmls) {
    this.muleXmls = existingXmls;
  }

  public List<MuleXml> getXmls() {
    return new ArrayList<>(diffs.values());
  }

  public void addConfig(String fileName, Configuration configuration) {
    if (diffs.get(fileName) == null) {
      diffs.put(fileName, new MuleXml(fileName));
    }
    diffs.get(fileName).addConfiguration(configuration);
  }

  public void addFlow(String fileName, Flow flow) {
    if (diffs.get(fileName) == null) {
      diffs.put(fileName, new MuleXml(fileName));
    }
    diffs.get(fileName).addFlow(flow);
  }

  public boolean containsConfig(Configuration configuration) {
    for (Entry<String, Document> entry : muleXmls.entrySet()) {
      if (configuration.exists(entry.getValue())) {
        return true;
      }
    }
    return false;
  }

  public boolean containsFlow(Flow flow) {
    for (Entry<String, Document> entry : muleXmls.entrySet()) {
      if (flow.exists(entry.getValue())) {
        return true;
      }
    }
    return false;
  }
}
