/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model;

import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.OnErrorFlow;

public class ErrorHandler
extends Configuration {
    private static final Namespace muleCoreNamespace = Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core");
    private static final XPathExpression<Element> configExpression = XPathFactory.instance().compile("//*/*[local-name()='error-handler']", Filters.element((Namespace)muleCoreNamespace));
    protected final List<OnErrorFlow> onErrorFlows = new ArrayList<OnErrorFlow>();
    protected final Configuration globalErrorHandler;

    public ErrorHandler(String name) {
        super(name);
        this.globalErrorHandler = null;
    }

    public ErrorHandler(String name, Configuration globalErrorHandler) {
        super(name);
        this.globalErrorHandler = globalErrorHandler;
    }

    public void addOnErrorFlow(OnErrorFlow flow) {
        this.onErrorFlows.add(flow);
    }

    @Override
    public void transformToXml(Element element) {
        Element errorHandler = new Element("error-handler", muleCoreNamespace);
        errorHandler.setAttribute("name", this.name);
        if (this.globalErrorHandler != null) {
            errorHandler.setAttribute("ref", this.globalErrorHandler.getName());
        }
        this.onErrorFlows.forEach(muleElement -> muleElement.transformToXml(errorHandler));
        element.addContent((Content)errorHandler);
    }

    @Override
    public boolean exists(Document document) {
        List elementList = configExpression.evaluate((Object)document);
        for (Element element : elementList) {
            Attribute name = element.getAttribute("name");
            if (!this.getName().equals(name.getValue())) continue;
            return true;
        }
        return false;
    }
}

