/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.mule.apikit.xml.MuleElement;

import java.util.ArrayList;
import java.util.List;

public abstract class Flow implements MuleElement, Named {

  protected final String name;
  protected final List<MuleElement> muleElements = new ArrayList<>();

  public Flow(String name) {
    this.name = name;
  }

  public void addMuleElement(MuleElement processor) {
    this.muleElements.add(processor);
  }

  public List<MuleElement> getMuleElements() {
    return muleElements;
  }

  @Override
  public String getName() {
    return this.name;
  }
}
