/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import static org.jdom2.xpath.XPathFactory.instance;

import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Processor;

public class EntityListener extends Processor {

  private static final Namespace odataNamespace = Namespace
      .getNamespace("apikit-odata", "http://www.mulesoft.org/schema/mule/apikit-odata");

  private static final XPathExpression<Element> entityListenerExpression =
      instance().compile("//*/*[local-name()='request-entity-listener']",
                         Filters.element(odataNamespace));

  public EntityListener(Configuration configuration) {
    super("request-entity-listener", configuration);
  }

  @Override
  public void transformToXml(Element element) {
    Element entityListener = new Element(name, odataNamespace);
    entityListener.setAttribute("config-ref", configuration.getName());
    parameters.entrySet()
        .forEach(entry -> entityListener.setAttribute(entry.getKey(), entry.getValue()));
    element.addContent(entityListener);
  }

  @Override
  public boolean exists(Document document) {
    List<Element> elementList = entityListenerExpression.evaluate(document);
    for (Element element : elementList) {
      String configRef = element.getAttribute("config-ref").getValue();
      String path = element.getAttribute("path").getValue();
      String method = element.getAttribute("method").getValue();
      if (getConfiguration().getName().equals(configRef) &&
          parameters.get("path").equals(path) &&
          parameters.get("method").equals(method)) {
        return true;
      }
    }
    return false;
  }
}
