/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit;

import java.io.File;
import java.util.Map;
import org.jdom2.Document;
import org.mule.apikit.xml.XmlHandler;

public interface ScaffoldingConfig {

  /**
   * @return api File
   */
  File api();

  /**
   * @return a list of @model.MuleXml
   */
  Map<String, Document> existingXmls();

  /**
   * @return Map with custom configurations for scaffolding
   */
  Map<String, String> customConfigs();

  XmlHandler getXmlHandler();
}
