/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.mule.apikit.xml.MuleElement;

import java.util.HashMap;
import java.util.Map;

public abstract class Processor implements MuleElement, Named {

  /**
   * Represents config-ref
   */
  protected final Configuration configuration;

  /**
   * Processor parameters
   */
  protected final Map<String, String> parameters = new HashMap<>();

  protected final String name;

  public Processor(String name, Configuration configuration) {
    this.name = name;
    this.configuration = configuration;
  }

  public Configuration getConfiguration() {
    return configuration;
  }

  public Map<String, String> getParameters() {
    return parameters;
  }

  public void setParameter(String name, String value) {
    parameters.put(name, value);
  }

  @Override
  public String getName() {
    return this.name;
  }


}
