/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.Element;

import java.io.File;

public class SetVariableEE extends DwlElement {

  private final String variableName;

  public SetVariableEE(String variableName, String payload) {
    super(payload);
    this.variableName = variableName;
  }

  public SetVariableEE(String variableName, File resource) {
    super(resource);
    this.variableName = variableName;
  }

  @Override
  protected String getElementName() {
    return "set-variable";
  }

  @Override
  protected void enrichDwlElement(Element dwlElement) {
    dwlElement.setAttribute("variableName", variableName);
  }
}
