/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Processor;

public class SerializeEntityOperation extends Processor {

  private static final Namespace odataNamespace = Namespace
      .getNamespace("apikit-odata", "http://www.mulesoft.org/schema/mule/apikit-odata");

  private final String inboundContent = "#[%dw 2.0 output application/json --- payload]";

  public SerializeEntityOperation(Configuration configuration) {
    super("serialize-entity", configuration);
  }

  @Override
  public void transformToXml(Element element) {
    Element serializeEntity = new Element(name, odataNamespace);
    serializeEntity.setAttribute("config-ref", configuration.getName());
    parameters.entrySet()
        .forEach(entry -> serializeEntity.setAttribute(entry.getKey(), entry.getValue()));


    Element inboundContent = new Element("inbound-content", odataNamespace);
    inboundContent.addContent(this.inboundContent);

    serializeEntity.addContent(inboundContent);

    element.addContent(serializeEntity);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }
}
