/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.utils;

import org.apache.olingo.client.core.edm.ClientCsdlEdmProvider;
import org.apache.olingo.client.core.serialization.ClientODataDeserializerImpl;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Common Schema Definition Language (CSDL) provider.
 */
public class CsdlEdmProvider extends CsdlAbstractEdmProvider {

  private final CsdlAbstractEdmProvider csdlEdmProvider;

  public CsdlEdmProvider(InputStream serviceDefinition) {
    this.csdlEdmProvider = new ClientCsdlEdmProvider(getXmlSchemas(serviceDefinition));
  }

  private Map<String, CsdlSchema> getXmlSchemas(InputStream stream) {
    return new ClientODataDeserializerImpl(false, ContentType.APPLICATION_XML)
        .toMetadata(stream)
        .getSchemaByNsOrAlias();
  }

  @Override
  public CsdlEnumType getEnumType(final FullQualifiedName enumTypeName) throws ODataException {
    return csdlEdmProvider.getEnumType(enumTypeName);
  }

  @Override
  public CsdlTypeDefinition getTypeDefinition(final FullQualifiedName typeDefinitionName) throws ODataException {
    return csdlEdmProvider.getTypeDefinition(typeDefinitionName);
  }

  @Override
  public CsdlEntityType getEntityType(final FullQualifiedName entityTypeName) throws ODataException {
    return csdlEdmProvider.getEntityType(entityTypeName);
  }

  @Override
  public CsdlComplexType getComplexType(final FullQualifiedName complexTypeName) throws ODataException {
    return csdlEdmProvider.getComplexType(complexTypeName);
  }

  @Override
  public List<CsdlAction> getActions(final FullQualifiedName actionName) throws ODataException {
    return csdlEdmProvider.getActions(actionName);
  }

  @Override
  public List<CsdlFunction> getFunctions(final FullQualifiedName functionName) throws ODataException {
    return csdlEdmProvider.getFunctions(functionName);
  }

  @Override
  public CsdlTerm getTerm(final FullQualifiedName termName) throws ODataException {
    return csdlEdmProvider.getTerm(termName);
  }

  @Override
  public CsdlEntitySet getEntitySet(final FullQualifiedName entityContainer, final String entitySetName)
      throws ODataException {
    return csdlEdmProvider.getEntitySet(entityContainer, entitySetName);
  }

  @Override
  public CsdlSingleton getSingleton(final FullQualifiedName entityContainer, final String singletonName)
      throws ODataException {
    return csdlEdmProvider.getSingleton(entityContainer, singletonName);
  }

  @Override
  public CsdlActionImport getActionImport(final FullQualifiedName entityContainer, final String actionImportName)
      throws ODataException {
    return csdlEdmProvider.getActionImport(entityContainer, actionImportName);
  }

  @Override
  public CsdlFunctionImport getFunctionImport(final FullQualifiedName entityContainer, final String functionImportName)
      throws ODataException {
    return csdlEdmProvider.getFunctionImport(entityContainer, functionImportName);
  }

  @Override
  public CsdlEntityContainerInfo getEntityContainerInfo(final FullQualifiedName entityContainerName)
      throws ODataException {
    return csdlEdmProvider.getEntityContainerInfo(entityContainerName);
  }

  @Override
  public List<CsdlAliasInfo> getAliasInfos() throws ODataException {
    return csdlEdmProvider.getAliasInfos();
  }

  @Override
  public List<CsdlSchema> getSchemas() throws ODataException {
    return csdlEdmProvider.getSchemas();
  }

  @Override
  public CsdlEntityContainer getEntityContainer() throws ODataException {
    return csdlEdmProvider.getEntityContainer();
  }

  @Override
  public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName, String qualifier) throws ODataException {
    return csdlEdmProvider.getAnnotationsGroup(targetName, qualifier);
  }

}
