/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.transform;

import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;

import java.util.List;

import static java.util.Collections.singletonList;

public class CsdlEdmFromRamlProvider extends CsdlAbstractEdmProvider {

  private CsdlSchema schema;

  public CsdlEdmFromRamlProvider(String ramlPath) {
    this.schema = new AMFWrapper(ramlPath).getSchema();
  }

  @Override
  public CsdlEnumType getEnumType(FullQualifiedName enumTypeName) {
    return schema.getEnumType(enumTypeName.getName());
  }

  @Override
  public CsdlTypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) {
    return schema.getTypeDefinition(typeDefinitionName.getName());
  }

  @Override
  public CsdlEntityType getEntityType(FullQualifiedName entityTypeName) {
    return schema.getEntityType(entityTypeName.getName());
  }

  @Override
  public CsdlComplexType getComplexType(FullQualifiedName complexTypeName) {
    return schema.getComplexType(complexTypeName.getName());
  }

  @Override
  public List<CsdlAction> getActions(FullQualifiedName actionName) {
    return schema.getActions(actionName.getName());
  }

  @Override
  public List<CsdlFunction> getFunctions(FullQualifiedName functionName) {
    return schema.getFunctions(functionName.getName());
  }

  @Override
  public CsdlTerm getTerm(FullQualifiedName termName) {
    return schema.getTerm(termName.getName());
  }

  @Override
  public CsdlEntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) {
    // Schema does not allow multiple entity containers
    CsdlEntityContainer csdlEntityContainer = schema.getEntityContainer();
    if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
      return csdlEntityContainer.getEntitySet(entitySetName);
    }
    return null;
  }

  @Override
  public CsdlSingleton getSingleton(FullQualifiedName entityContainer, String singletonName) {
    // Schema does not allow multiple entity containers
    CsdlEntityContainer csdlEntityContainer = schema.getEntityContainer();
    if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
      return csdlEntityContainer.getSingleton(singletonName);
    }
    return null;
  }

  @Override
  public CsdlActionImport getActionImport(FullQualifiedName entityContainer, String actionImportName) {
    CsdlEntityContainer csdlEntityContainer = schema.getEntityContainer();
    if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
      return csdlEntityContainer.getActionImport(actionImportName);
    }
    return null;
  }

  @Override
  public CsdlFunctionImport getFunctionImport(FullQualifiedName entityContainer, String functionImportName) {
    CsdlEntityContainer csdlEntityContainer = schema.getEntityContainer();
    if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
      return csdlEntityContainer.getFunctionImport(functionImportName);
    }
    return null;
  }

  @Override
  public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) {
    CsdlEntityContainer csdlEntityContainer = schema.getEntityContainer();
    CsdlEntityContainerInfo containerInfo = new CsdlEntityContainerInfo();
    containerInfo.setContainerName(new FullQualifiedName(schema.getNamespace(), csdlEntityContainer.getName()));
    containerInfo.setExtendsContainer(csdlEntityContainer.getExtendsContainerFQN());
    return containerInfo;
  }

  @Override
  public List<CsdlAliasInfo> getAliasInfos() {
    CsdlAliasInfo aliasInfo = new CsdlAliasInfo();
    aliasInfo.setAlias(schema.getAlias());
    aliasInfo.setNamespace(schema.getNamespace());
    return singletonList(aliasInfo);
  }

  @Override
  public List<CsdlSchema> getSchemas() {
    return singletonList(schema);
  }

  @Override
  public CsdlEntityContainer getEntityContainer() {
    return schema.getEntityContainer();
  }

  @Override
  public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName, String qualifier) {
    return schema.getAnnotationGroup(targetName.getName(), qualifier);
  }
}
