/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.transform;

import static amf.ProfileNames.RAML;
import static amf.client.AMF.init;
import static amf.client.AMF.raml10Parser;

import amf.client.model.document.Module;
import amf.client.model.domain.NodeShape;
import amf.client.parse.Raml10Parser;
import amf.client.validate.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.mule.apikit.transform.exception.ODataMetadataFormatException;

public class RAMLSpecParser {

  private final String ramlPath;

  public RAMLSpecParser(String ramlPath) {
    this.ramlPath = ramlPath;
  }

  public List<NodeShape> getNodeShapes() {
    try {
      init().get();
      Raml10Parser parser = raml10Parser();
      Module module = (Module) parser.parseFileAsync(ramlPath).get();

      List<ValidationResult> validationResults = parser
          .reportValidation(RAML()).get()
          .results();

      if (!validationResults.isEmpty()) {
        throw new ODataMetadataFormatException(createErrorMessage(validationResults));
      }

      List<NodeShape> nodeShapes = new ArrayList<>();

      module.declares().forEach(domainElement -> {
        if (domainElement instanceof NodeShape) {
          NodeShape nodeShape = (NodeShape) domainElement;
          nodeShapes.add(nodeShape);
        }
      });

      return nodeShapes;
    } catch (InterruptedException | ExecutionException e) {
      throw new ODataMetadataFormatException("AMF init failed", e);
    }
  }

  private String createErrorMessage(List<ValidationResult> validationResults) {
    StringBuilder errorMessage = new StringBuilder("Parse of odata.raml file failed: ");
    for (ValidationResult validationResult : validationResults) {
      errorMessage.append(validationResult.message());
      errorMessage.append("\n");
    }
    return errorMessage.toString();
  }
}
