/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.xml.MuleElement;

import java.io.File;

public abstract class DwlElement implements MuleElement {

  protected static final Namespace eeNamespace = Namespace
      .getNamespace("ee", "http://www.mulesoft.org/schema/mule/ee/core");

  protected final String payload;
  protected final File resource;

  protected DwlElement(String payload) {
    this.payload = payload;
    this.resource = null;
  }

  protected DwlElement(File resource) {
    this.payload = null;
    this.resource = resource;
  }

  @Override
  public void transformToXml(Element element) {
    Element dwlElement = buildDwlElement();
    enrichDwlElement(dwlElement);
    element.addContent(dwlElement);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }

  private Element buildDwlElement() {
    Element dwlElement = new Element(getElementName(), eeNamespace);
    if (payload != null) {
      dwlElement.addContent(new CDATA(payload));
    } else if (resource != null) {
      dwlElement.setAttribute("resource", resource.getPath());
    }
    return dwlElement;
  }

  /**
   * Extension point for implementations.
   *
   * @param dwlElement the XML Element being built.
   */
  protected void enrichDwlElement(Element dwlElement) {}

  /**
   * Get XML Element tag name.
   *
   * @return tag name
   */
  protected abstract String getElementName();
}
