/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.mule.apikit.model.Flow;
import org.mule.apikit.xml.MuleElement;

import java.util.List;

import static org.jdom2.xpath.XPathFactory.instance;

public class ODataFlow extends Flow implements MuleElement {

  private static final Namespace muleCoreNamespace = Namespace
      .getNamespace("http://www.mulesoft.org/schema/mule/core");

  private static final XPathExpression<Element> configExpression =
      instance().compile("//*/*[local-name()='flow']", Filters.element(muleCoreNamespace));

  public ODataFlow(String name) {
    super(name);
  }

  @Override
  public void transformToXml(Element element) {
    Element result = new Element("flow", muleCoreNamespace);
    result.setAttribute("name", name);
    element.addContent(result);
    muleElements.forEach(muleElement -> muleElement.transformToXml(result));
  }

  @Override
  public boolean exists(Document document) {
    return matchName(document) || matchElements(document);
  }

  public boolean matchElements(Document document) {
    return muleElements.stream().anyMatch(muleElement -> muleElement.exists(document));
  }

  public boolean matchName(Document document) {
    List<Element> elementList = configExpression.evaluate(document);
    for (Element element : elementList) {
      Attribute name = element.getAttribute("name");
      if (getName().equals(name.getValue())) {
        return true;
      }
    }
    return false;
  }

  @Override
  public boolean equals(Object other) {
    if (!(other instanceof ODataFlow)) {
      return false;
    }
    ODataFlow oDataFlow = (ODataFlow) other;
    List<MuleElement> otherMuleElements = oDataFlow.getMuleElements();
    return getMuleElements().stream().anyMatch(muleElement -> otherMuleElements.contains(muleElement));

  }
}
