/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata.model;

import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Processor;

public class RouteOperation
extends Processor {
    private static final Namespace odataNamespace = Namespace.getNamespace((String)"apikit-odata", (String)"http://www.mulesoft.org/schema/mule/apikit-odata");
    private static final XPathExpression<Element> routeExpression = XPathFactory.instance().compile("//*/*[local-name()='route']", Filters.element((Namespace)odataNamespace));

    public RouteOperation(Configuration configuration) {
        super("route", configuration);
    }

    @Override
    public void transformToXml(Element element) {
        Element routeOperation = new Element(this.name, odataNamespace);
        routeOperation.setAttribute("config-ref", this.configuration.getName());
        Element parameters = new Element("http-request-parameters", odataNamespace);
        this.parameters.entrySet().forEach(entry -> parameters.setAttribute((String)entry.getKey(), (String)entry.getValue()));
        routeOperation.addContent((Content)parameters);
        element.addContent((Content)routeOperation);
    }

    @Override
    public boolean exists(Document document) {
        List elementList = routeExpression.evaluate((Object)document);
        for (Element element : elementList) {
            Attribute configRef = element.getAttribute("config-ref");
            if (!this.getConfiguration().getName().equals(configRef.getValue())) continue;
            return true;
        }
        return false;
    }
}

