/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;


import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * Representation of Mule XML config file
 */
public class MuleXml implements Named {

  private final String name;
  private final List<Configuration> configurations = new LinkedList<>();

  private final List<Flow> flows = new ArrayList<>();

  public MuleXml(String name) {
    this.name = name;
  }

  public List<Configuration> getConfigurations() {
    return configurations;
  }

  public List<Flow> getFlows() {
    return flows;
  }

  public void addConfiguration(Configuration configuration) {
    this.configurations.add(configuration);
  }

  public void addFlow(Flow flow) {
    this.flows.add(flow);
  }

  @Override
  public String getName() {
    return this.name;
  }

}
