/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.xml.MuleElement;

public abstract class TypedValueElement implements MuleElement {

  protected static final Namespace muleCoreNamespace = Namespace
      .getNamespace("http://www.mulesoft.org/schema/mule/core");

  protected final String value;
  protected final String mimeType;
  protected final String encoding;

  public TypedValueElement(String value, String mimeType, String encoding) {
    this.value = value;
    this.mimeType = mimeType;
    this.encoding = encoding;
  }

  @Override
  public void transformToXml(Element element) {
    Element typedValueElement = buildTypedValueElement();
    enrichTypedValueElement(typedValueElement);
    element.addContent(typedValueElement);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }

  private Element buildTypedValueElement() {
    Element setPayloadElement = new Element(getElementName(), muleCoreNamespace);
    if (value != null) {
      setPayloadElement.setAttribute("value", value);
    }
    if (mimeType != null) {
      setPayloadElement.setAttribute("mimeType", mimeType);
    }
    if (encoding != null) {
      setPayloadElement.setAttribute("encoding", encoding);
    }
    return setPayloadElement;
  }

  /**
   * Extension point for implementations.
   *
   * @param typedValueElement the XML Element being built.
   */
  protected void enrichTypedValueElement(Element typedValueElement) {}

  /**
   * Get XML Element tag name.
   *
   * @return tag name
   */
  protected abstract String getElementName();
}
