/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model;

import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.xml.MuleElement;

public abstract class TypedValueElement
implements MuleElement {
    protected static final Namespace muleCoreNamespace = Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core");
    protected final String value;
    protected final String mimeType;
    protected final String encoding;

    public TypedValueElement(String value, String mimeType, String encoding) {
        this.value = value;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    @Override
    public void transformToXml(Element element) {
        Element typedValueElement = this.buildTypedValueElement();
        this.enrichTypedValueElement(typedValueElement);
        element.addContent((Content)typedValueElement);
    }

    @Override
    public boolean exists(Document document) {
        return false;
    }

    private Element buildTypedValueElement() {
        Element setPayloadElement = new Element(this.getElementName(), muleCoreNamespace);
        if (this.value != null) {
            setPayloadElement.setAttribute("value", this.value);
        }
        if (this.mimeType != null) {
            setPayloadElement.setAttribute("mimeType", this.mimeType);
        }
        if (this.encoding != null) {
            setPayloadElement.setAttribute("encoding", this.encoding);
        }
        return setPayloadElement;
    }

    protected void enrichTypedValueElement(Element typedValueElement) {
    }

    protected abstract String getElementName();
}

