/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata.model;

import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Flow;
import org.mule.apikit.xml.MuleElement;

public class ODataFlow
extends Flow
implements MuleElement {
    private static final Namespace muleCoreNamespace = Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core");
    private static final XPathExpression<Element> configExpression = XPathFactory.instance().compile("//*/*[local-name()='flow']", Filters.element((Namespace)muleCoreNamespace));

    public ODataFlow(String name) {
        super(name);
    }

    @Override
    public void transformToXml(Element element) {
        Element result = new Element("flow", muleCoreNamespace);
        result.setAttribute("name", this.name);
        element.addContent((Content)result);
        this.muleElements.forEach(muleElement -> muleElement.transformToXml(result));
    }

    @Override
    public boolean exists(Document document) {
        return this.matchName(document) || this.matchElements(document);
    }

    public boolean matchElements(Document document) {
        return this.muleElements.stream().anyMatch(muleElement -> muleElement.exists(document));
    }

    public boolean matchName(Document document) {
        List elementList = configExpression.evaluate((Object)document);
        for (Element element : elementList) {
            Attribute name = element.getAttribute("name");
            if (!this.getName().equals(name.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ODataFlow)) {
            return false;
        }
        ODataFlow oDataFlow = (ODataFlow)other;
        List<MuleElement> otherMuleElements = oDataFlow.getMuleElements();
        return this.getMuleElements().stream().anyMatch(muleElement -> otherMuleElements.contains(muleElement));
    }
}

