/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit;

import java.io.InputStream;
import java.util.List;
import java.util.Map;


public interface ScaffoldingResult {

  /**
   * Check if the scaffolding process was successful
   */
  boolean success();

  /**
   * @return Map<fileName, Content> with fileNames and Contents as InputStream
   */
  Map<String, InputStream> generatedMuleXmls();

  /**
   * @return List of errors in case scaffolding was not success, otherwise emptyList
   */
  List<ScaffoldingError> errors();

}
