/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.mule.apikit.TransformToCSDL;
import org.mule.apikit.transform.CsdlEdmFromRamlProvider;
import org.mule.apikit.transform.exception.ODataMetadataFormatException;
import org.mule.apikit.xml.XmlHandler;

public class RAMLToCSDL
implements TransformToCSDL {
    @Override
    public InputStream transform(File input) throws ODataMetadataFormatException {
        try {
            OData oData = OData.newInstance();
            ServiceMetadata serviceMetadata = oData.createServiceMetadata((CsdlEdmProvider)new CsdlEdmFromRamlProvider(input.toURI().toString()), new ArrayList());
            InputStream csdlXml = oData.createSerializer(ContentType.APPLICATION_XML).metadataDocument(serviceMetadata).getContent();
            Document output = XmlHandler.getSaxBuilder().build(csdlXml);
            return new ByteArrayInputStream(new XMLOutputter(Format.getPrettyFormat()).outputString(output).getBytes());
        }
        catch (IOException | SerializerException | JDOMException e) {
            throw new ODataMetadataFormatException("Cannot create metadata serializer");
        }
    }
}

