/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model;

import java.io.File;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.xml.MuleElement;

public abstract class DwlElement
implements MuleElement {
    protected static final Namespace eeNamespace = Namespace.getNamespace((String)"ee", (String)"http://www.mulesoft.org/schema/mule/ee/core");
    protected final String payload;
    protected final File resource;

    protected DwlElement(String payload) {
        this.payload = payload;
        this.resource = null;
    }

    protected DwlElement(File resource) {
        this.payload = null;
        this.resource = resource;
    }

    @Override
    public void transformToXml(Element element) {
        Element dwlElement = this.buildDwlElement();
        this.enrichDwlElement(dwlElement);
        element.addContent((Content)dwlElement);
    }

    @Override
    public boolean exists(Document document) {
        return false;
    }

    private Element buildDwlElement() {
        Element dwlElement = new Element(this.getElementName(), eeNamespace);
        if (this.payload != null) {
            dwlElement.addContent((Content)new CDATA(this.payload));
        } else if (this.resource != null) {
            dwlElement.setAttribute("resource", this.resource.getPath());
        }
        return dwlElement;
    }

    protected void enrichDwlElement(Element dwlElement) {
    }

    protected abstract String getElementName();
}

