/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.transform;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.mule.apikit.transform.AMFWrapper;

public class CsdlEdmFromRamlProvider
extends CsdlAbstractEdmProvider {
    private CsdlSchema schema;

    public CsdlEdmFromRamlProvider(String ramlPath) {
        this.schema = new AMFWrapper(ramlPath).getSchema();
    }

    public CsdlEnumType getEnumType(FullQualifiedName enumTypeName) {
        return this.schema.getEnumType(enumTypeName.getName());
    }

    public CsdlTypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) {
        return this.schema.getTypeDefinition(typeDefinitionName.getName());
    }

    public CsdlEntityType getEntityType(FullQualifiedName entityTypeName) {
        return this.schema.getEntityType(entityTypeName.getName());
    }

    public CsdlComplexType getComplexType(FullQualifiedName complexTypeName) {
        return this.schema.getComplexType(complexTypeName.getName());
    }

    public List<CsdlAction> getActions(FullQualifiedName actionName) {
        return this.schema.getActions(actionName.getName());
    }

    public List<CsdlFunction> getFunctions(FullQualifiedName functionName) {
        return this.schema.getFunctions(functionName.getName());
    }

    public CsdlTerm getTerm(FullQualifiedName termName) {
        return this.schema.getTerm(termName.getName());
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) {
        CsdlEntityContainer csdlEntityContainer = this.schema.getEntityContainer();
        if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
            return csdlEntityContainer.getEntitySet(entitySetName);
        }
        return null;
    }

    public CsdlSingleton getSingleton(FullQualifiedName entityContainer, String singletonName) {
        CsdlEntityContainer csdlEntityContainer = this.schema.getEntityContainer();
        if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
            return csdlEntityContainer.getSingleton(singletonName);
        }
        return null;
    }

    public CsdlActionImport getActionImport(FullQualifiedName entityContainer, String actionImportName) {
        CsdlEntityContainer csdlEntityContainer = this.schema.getEntityContainer();
        if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
            return csdlEntityContainer.getActionImport(actionImportName);
        }
        return null;
    }

    public CsdlFunctionImport getFunctionImport(FullQualifiedName entityContainer, String functionImportName) {
        CsdlEntityContainer csdlEntityContainer = this.schema.getEntityContainer();
        if (csdlEntityContainer != null && csdlEntityContainer.getName().equals(entityContainer.getName())) {
            return csdlEntityContainer.getFunctionImport(functionImportName);
        }
        return null;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) {
        CsdlEntityContainer csdlEntityContainer = this.schema.getEntityContainer();
        CsdlEntityContainerInfo containerInfo = new CsdlEntityContainerInfo();
        containerInfo.setContainerName(new FullQualifiedName(this.schema.getNamespace(), csdlEntityContainer.getName()));
        containerInfo.setExtendsContainer(csdlEntityContainer.getExtendsContainerFQN());
        return containerInfo;
    }

    public List<CsdlAliasInfo> getAliasInfos() {
        CsdlAliasInfo aliasInfo = new CsdlAliasInfo();
        aliasInfo.setAlias(this.schema.getAlias());
        aliasInfo.setNamespace(this.schema.getNamespace());
        return Collections.singletonList(aliasInfo);
    }

    public List<CsdlSchema> getSchemas() {
        return Collections.singletonList(this.schema);
    }

    public CsdlEntityContainer getEntityContainer() {
        return this.schema.getEntityContainer();
    }

    public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName, String qualifier) {
        return this.schema.getAnnotationGroup(targetName.getName(), qualifier);
    }
}

