/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata.model;

import java.util.List;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.xml.MuleElement;

public class ODataConfig
extends Configuration
implements MuleElement {
    private static final Namespace odataNamespace = Namespace.getNamespace((String)"apikit-odata", (String)"http://www.mulesoft.org/schema/mule/apikit-odata");
    private static final XPathExpression<Element> configExpression = XPathFactory.instance().compile("//*/*[local-name()='config']", Filters.element((Namespace)odataNamespace));
    private String api;

    public ODataConfig(String name, String api) {
        super(name);
        this.api = api;
    }

    @Override
    public void transformToXml(Element element) {
        Element result = new Element("config", odataNamespace);
        result.setAttribute("name", this.name);
        result.setAttribute("apiDefinition", this.api);
        element.addContent((Content)result);
    }

    @Override
    public boolean exists(Document document) {
        List elementList = configExpression.evaluate((Object)document);
        for (Element element : elementList) {
            Attribute name = element.getAttribute("name");
            if (!this.getName().equals(name.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ODataConfig)) {
            return false;
        }
        ODataConfig that = (ODataConfig)o;
        return Objects.equals(this.api, that.api) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.api);
    }
}

