/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata.model;

import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.xml.MuleElement;

public class ListenerConfig
extends Configuration
implements MuleElement {
    private static final Namespace listenerNamespace = Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http");
    private static final XPathExpression<Element> configExpression = XPathFactory.instance().compile("//*/*[local-name()='listener-config']", Filters.element((Namespace)listenerNamespace));

    public ListenerConfig(String name) {
        super(name);
    }

    @Override
    public void transformToXml(Element element) {
        Element listener = new Element("listener-config", listenerNamespace);
        listener.setAttribute("name", this.name);
        Element connection = new Element("listener-connection", listenerNamespace);
        connection.setAttribute("host", "0.0.0.0");
        connection.setAttribute("port", "8081");
        listener.addContent((Content)connection);
        element.addContent((Content)listener);
    }

    @Override
    public boolean exists(Document document) {
        List elementList = configExpression.evaluate((Object)document);
        for (Element element : elementList) {
            Attribute name = element.getAttribute("name");
            if (!this.getName().equals(name.getValue())) continue;
            return true;
        }
        return false;
    }
}

