/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.amf.impl.ParserWrapperAmf;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.parser.service.ComponentScaffoldingError;
import org.mule.parser.service.CompositeScaffoldingError;
import org.mule.parser.service.ParserServiceException;
import org.mule.parser.service.ScaffoldingErrorType;
import org.mule.parser.service.SimpleScaffoldingError;
import org.mule.parser.service.logger.Logger;
import org.mule.parser.service.logger.LoggerFactory;
import org.mule.raml.implv1.ParserWrapperV1;
import org.mule.raml.implv2.ParserWrapperV2;
import org.mule.raml.interfaces.ParserType;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.raml.interfaces.parser.rule.IValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.rule.Severity;

public class ParserService {
    public static final String MULE_APIKIT_PARSER = "mule.apikit.parser";
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(ParserService.class);
    private final Logger LOGGER;
    private final List<ComponentScaffoldingError> parsingErrors = new ArrayList<ComponentScaffoldingError>();

    public ParserService() {
        this(DEFAULT_LOGGER);
    }

    public ParserService(Logger logger) {
        this.LOGGER = logger;
    }

    public List<ComponentScaffoldingError> getParsingErrors() {
        return this.parsingErrors;
    }

    public ParserWrapper getParser(ApiRef apiRef) {
        return this.getParser(apiRef, ParserType.AUTO);
    }

    public ParserWrapper getParser(ApiRef apiRef, ParserType parserType) {
        ParserType overridden = this.getOverriddenParserType();
        if (overridden != ParserType.AUTO) {
            return this.getParserFor(apiRef, overridden);
        }
        return this.getParserFor(apiRef, parserType);
    }

    private ParserType getOverriddenParserType() {
        String parserValue = System.getProperty(MULE_APIKIT_PARSER);
        if (ParserType.AMF.name().equals(parserValue)) {
            return ParserType.AMF;
        }
        if (ParserType.RAML.name().equals(parserValue)) {
            return ParserType.RAML;
        }
        return ParserType.AUTO;
    }

    private ParserWrapper getParserFor(ApiRef apiRef, ParserType parserType) {
        try {
            Object parserWrapper = parserType == ParserType.RAML ? ParserService.createRamlParserWrapper(apiRef) : ParserWrapperAmf.create((ApiRef)apiRef, (boolean)false);
            IValidationReport validationReport = parserWrapper.validationReport();
            if (validationReport.conforms()) {
                return parserWrapper;
            }
            ScaffoldingErrorType scaffoldingErrorType = parserWrapper.getParserType().equals((Object)ParserType.RAML) ? ScaffoldingErrorType.RAML : ScaffoldingErrorType.AMF;
            List errorsFound = validationReport.getResults();
            CompositeScaffoldingError validationError = new CompositeScaffoldingError(String.format("Validation failed using parser type : %s, in file : %s", parserWrapper.getParserType(), apiRef.getLocation()), scaffoldingErrorType, errorsFound.stream().map(e -> new SimpleScaffoldingError(e.getMessage())).collect(Collectors.toList()));
            this.parsingErrors.add(validationError);
            return this.applyFallback(apiRef, parserType, errorsFound);
        }
        catch (ParserException | ParserServiceException e2) {
            throw new ParserServiceException(e2);
        }
        catch (Exception e3) {
            List<IValidationResult> errors = Collections.singletonList(IValidationResult.fromException((Exception)e3));
            CompositeScaffoldingError exceptionError = new CompositeScaffoldingError(String.format("Exception parsing errors in file : %s", apiRef.getLocation()), parserType.equals((Object)ParserType.RAML) ? ScaffoldingErrorType.RAML : ScaffoldingErrorType.AMF, errors.stream().map(er -> new SimpleScaffoldingError(er.getMessage())).collect(Collectors.toList()));
            this.parsingErrors.add(exceptionError);
            return this.applyFallback(apiRef, parserType, errors);
        }
    }

    private ParserWrapper applyFallback(ApiRef apiRef, ParserType parserType, List<IValidationResult> errorsFound) throws ParserServiceException {
        if (parserType == ParserType.AUTO) {
            ParserWrapper fallbackParser = ParserService.createRamlParserWrapper(apiRef);
            if (fallbackParser.validationReport().conforms()) {
                this.logErrors(errorsFound, Severity.WARNING);
                return fallbackParser;
            }
            CompositeScaffoldingError fallbackError = new CompositeScaffoldingError(String.format("Validation failed using fallback parser type : %s, in file : %s", fallbackParser.getParserType(), apiRef.getLocation()), ScaffoldingErrorType.RAML, fallbackParser.validationReport().getResults().stream().map(e -> new SimpleScaffoldingError(e.getMessage())).collect(Collectors.toList()));
            this.parsingErrors.add(fallbackError);
        }
        this.logErrors(errorsFound);
        throw new ParserServiceException(ParserService.buildErrorMessage(errorsFound));
    }

    private void logErrors(List<IValidationResult> validationResults) {
        validationResults.forEach(error -> this.logError((IValidationResult)error, error.getSeverity()));
    }

    private void logErrors(List<IValidationResult> validationResults, Severity overridenSeverity) {
        validationResults.forEach(error -> this.logError((IValidationResult)error, overridenSeverity));
    }

    private void logError(IValidationResult error, Severity severity) {
        if (severity == Severity.INFO) {
            this.LOGGER.info(error.getMessage());
        } else if (severity == Severity.WARNING) {
            this.LOGGER.warn(error.getMessage());
        } else {
            this.LOGGER.error(error.getMessage());
        }
    }

    private static String buildErrorMessage(List<IValidationResult> validationResults) {
        StringBuilder message = new StringBuilder("Invalid API descriptor -- errors found: ");
        message.append(validationResults.size()).append("\n\n");
        for (IValidationResult error : validationResults) {
            message.append(error.getMessage()).append("\n");
        }
        return message.toString();
    }

    private static ParserWrapper createRamlParserWrapper(ApiRef apiRef) {
        String path = apiRef.getLocation();
        ResourceLoader apiLoader = apiRef.getResourceLoader().orElse(null);
        if (ApiVendor.RAML_08.equals((Object)apiRef.getVendor())) {
            return ParserService.createRamlParserWrapperV1(path, apiLoader);
        }
        return ParserService.createRamlParserWrapperV2(path, apiLoader);
    }

    private static ParserWrapperV1 createRamlParserWrapperV1(String path, ResourceLoader apiLoader) {
        ParserWrapperV1 parserWrapperV1;
        if (apiLoader != null) {
            org.raml.parser.loader.ResourceLoader[] resourceLoaderArray = new org.raml.parser.loader.ResourceLoader[2];
            resourceLoaderArray[0] = ParserWrapperV1.getResourceLoaderForPath((String)path);
            resourceLoaderArray[1] = arg_0 -> ((ResourceLoader)apiLoader).getResourceAsStream(arg_0);
            parserWrapperV1 = new ParserWrapperV1(path, resourceLoaderArray);
        } else {
            parserWrapperV1 = new ParserWrapperV1(path);
        }
        return parserWrapperV1;
    }

    private static ParserWrapperV2 createRamlParserWrapperV2(String path, ResourceLoader apiLoader) {
        ParserWrapperV2 parserWrapperV2;
        if (apiLoader != null) {
            org.raml.v2.api.loader.ResourceLoader[] resourceLoaderArray = new org.raml.v2.api.loader.ResourceLoader[2];
            resourceLoaderArray[0] = ParserWrapperV2.getResourceLoaderForPath((String)path);
            resourceLoaderArray[1] = arg_0 -> ((ResourceLoader)apiLoader).getResourceAsStream(arg_0);
            parserWrapperV2 = new ParserWrapperV2(path, resourceLoaderArray);
        } else {
            parserWrapperV2 = new ParserWrapperV2(path);
        }
        return parserWrapperV2;
    }
}

