/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service;

import java.util.Optional;
import org.mule.apikit.model.api.ApiReference;
import org.mule.parser.service.ParserMode;
import org.mule.parser.service.result.ParseResult;

public class ParserService {
    private static final String MULE_APIKIT_PARSER = "mule.apikit.parser";

    public ParseResult parse(ApiReference ref) {
        return this.parse(ref, ParserMode.AUTO);
    }

    public ParseResult parse(ApiReference ref, ParserMode parserConfig) {
        ParserMode parser = this.getOverrideParserConfig().orElse(parserConfig);
        return parser.getStrategy().parse(ref);
    }

    private Optional<ParserMode> getOverrideParserConfig() {
        String parserType = System.getProperty(MULE_APIKIT_PARSER);
        if (parserType == null) {
            return Optional.empty();
        }
        if (ParserMode.AMF.name().equals(parserType)) {
            return Optional.of(ParserMode.AMF);
        }
        if (ParserMode.RAML.name().equals(parserType)) {
            return Optional.of(ParserMode.RAML);
        }
        return Optional.of(ParserMode.AUTO);
    }
}

