/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl;

import amf.ProfileName;
import amf.ProfileNames;
import amf.client.environment.Environment;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.WebApi;
import amf.client.parse.Oas20Parser;
import amf.client.parse.Oas20YamlParser;
import amf.client.parse.Parser;
import amf.client.parse.Raml08Parser;
import amf.client.parse.Raml10Parser;
import amf.client.parse.RamlParser;
import amf.client.plugins.AMFPlugin;
import amf.client.validate.ValidationReport;
import amf.client.validate.ValidationResult;
import amf.core.AMF;
import amf.plugins.features.validation.AMFValidatorPlugin;
import amf.plugins.xml.XmlValidationPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FilenameUtils;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentParser {
    private static final Logger logger = LoggerFactory.getLogger(DocumentParser.class);

    private DocumentParser() {
    }

    private static <T, U> U handleFuture(CompletableFuture<T> f) throws ParserException {
        try {
            return (U)f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ParserException("An error happened while parsing the api. Message: " + e.getMessage(), e);
        }
    }

    public static Document parseFile(Parser parser, URI uri) throws ParserException {
        return DocumentParser.parseFile(parser, uri, false);
    }

    public static Document parseFile(Parser parser, URI uri, boolean validate) throws ParserException {
        return DocumentParser.parseFile(parser, DocumentParser.uriToPath(uri), validate);
    }

    public static Document parseFile(Parser parser, String apiPath, boolean validate) throws ParserException {
        List results;
        ProfileName profile;
        ValidationReport parsingReport;
        Document document = DocumentParser.parseFile(parser, apiPath);
        if (validate && !(parsingReport = DocumentParser.getParsingReport(parser, profile = parser instanceof Oas20Parser ? ProfileNames.OAS() : ProfileNames.RAML())).conforms() && !(results = parsingReport.results()).isEmpty()) {
            String message = ((ValidationResult)results.get(0)).message();
            throw new ParserException(message);
        }
        return document;
    }

    private static String uriToPath(URI uri) {
        String path = uri.toString();
        return URLDecoder.decode(path);
    }

    private static Document parseFile(Parser parser, String url) throws ParserException {
        return (Document)DocumentParser.handleFuture(parser.parseFileAsync(url));
    }

    public static Parser getParserForApi(ApiRef apiRef, Environment environment) {
        ApiVendor vendor = apiRef.getVendor();
        switch (vendor) {
            case OAS: 
            case OAS_20: {
                if ("JSON".equalsIgnoreCase(apiRef.getFormat())) {
                    return new Oas20Parser(environment);
                }
                return new Oas20YamlParser(environment);
            }
            case RAML_08: {
                return new Raml08Parser(environment);
            }
            case RAML_10: {
                return new Raml10Parser(environment);
            }
        }
        return new RamlParser(environment);
    }

    public static WebApi getWebApi(Parser parser, URI uri) throws ParserException {
        return DocumentParser.getWebApi((BaseUnit)DocumentParser.parseFile(parser, uri));
    }

    public static WebApi getWebApi(BaseUnit baseUnit) throws ParserException {
        Document document = (Document)amf.client.AMF.resolveRaml10((BaseUnit)baseUnit);
        return (WebApi)document.encodes();
    }

    public static ValidationReport getParsingReport(Parser parser, ProfileName profile) throws ParserException {
        return (ValidationReport)DocumentParser.handleFuture(parser.reportValidation(profile));
    }

    public static VendorEx getVendor(URI api) {
        String ext = FilenameUtils.getExtension((String)api.getPath());
        return "RAML".equalsIgnoreCase(ext) ? VendorEx.RAML : DocumentParser.deduceVendorFromContent(api);
    }

    /*
     * Exception decompiling
     */
    private static VendorEx deduceVendorFromContent(URI api) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getFirstLine(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            return line;
        }
        return "";
    }

    static {
        try {
            amf.client.AMF.init().get();
            AMFValidatorPlugin.withEnabledValidation((boolean)true);
            AMF.registerPlugin((AMFPlugin)new XmlValidationPlugin());
        }
        catch (Exception e) {
            logger.error("Error initializing AMF", (Throwable)e);
        }
    }

    public static enum VendorEx {
        RAML,
        OAS20_JSON,
        OAS20_YAML;

    }
}

