/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.loader;

import amf.client.remote.Content;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.mule.raml.interfaces.loader.ResourceLoader;

public class ProvidedResourceLoader
implements amf.client.resource.ResourceLoader {
    private ResourceLoader resourceLoader;

    public ProvidedResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public CompletableFuture<Content> fetch(String resourceName) {
        CompletableFuture<Content> future = new CompletableFuture<Content>();
        if (resourceName == null || resourceName.isEmpty()) {
            throw new RuntimeException("Failed to apply.");
        }
        URI resource = this.resourceLoader.getResource(resourceName);
        if (resource != null) {
            InputStream stream = this.resourceLoader.getResourceAsStream(resourceName);
            try {
                String resourceAsString = IOUtils.toString((InputStream)stream);
                Content content = new Content(resourceAsString, resource.toString());
                future.complete(content);
            }
            catch (IOException e) {
                future.completeExceptionally(new RuntimeException("Failed to fetch resource '" + resourceName + "'"));
            }
        } else {
            future.completeExceptionally(new Exception("Failed to fetch resource '" + resourceName + "'"));
        }
        return future;
    }

    private CompletableFuture<Content> fail() {
        return CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException("Failed to apply.");
        });
    }
}

