/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl;

import amf.client.execution.BaseExecutionEnvironment;
import amf.client.execution.ExecutionEnvironment;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.WebApi;
import amf.client.plugins.AMFPlugin;
import amf.client.validate.ValidationReport;
import amf.core.AMF;
import amf.plugins.xml.XmlValidationPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.amf.impl.parser.factory.AMFParserWrapper;
import org.mule.amf.impl.parser.factory.AMFParserWrapperFactory;
import org.mule.amf.impl.parser.rule.ApiValidationResultImpl;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ApiParser;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.apikit.validation.DefaultApiValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFParser
implements ApiParser {
    private static final Logger logger = LoggerFactory.getLogger(AMFParser.class);
    private URI apiUri;
    private ApiReference apiRef;
    private AMFParserWrapper parser;
    private LazyValue<WebApi> webApi;
    private LazyValue<Document> document;
    private ExecutionEnvironment executionEnvironment;

    @Deprecated
    public AMFParser(ApiReference apiRef, boolean validate, ScheduledExecutorService scheduler) {
        this.initializeParser(apiRef, new ExecutionEnvironment(scheduler));
    }

    @Deprecated
    public AMFParser(ApiReference apiRef, boolean validate) {
        this.initializeParser(apiRef, new ExecutionEnvironment());
    }

    public AMFParser(ApiReference apiRef, ScheduledExecutorService scheduler) {
        this.initializeParser(apiRef, new ExecutionEnvironment(scheduler));
    }

    public AMFParser(ApiReference apiRef) {
        this.initializeParser(apiRef, new ExecutionEnvironment());
    }

    private void initializeParser(ApiReference apiRef, ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        this.apiUri = apiRef.getPathAsUri();
        this.document = new LazyValue<Document>(() -> this.parser.parseApi(this.apiUri));
        this.webApi = new LazyValue<WebApi>(() -> (WebApi)this.document.get().encodes());
        this.apiRef = apiRef;
        this.initAMF();
        this.parser = AMFParserWrapperFactory.getParser(apiRef, executionEnvironment);
    }

    private List<String> getReferences(List<BaseUnit> references) {
        ArrayList<String> result = new ArrayList<String>();
        this.appendReferences(references, new HashSet<String>(), result);
        return result;
    }

    private void appendReferences(List<BaseUnit> references, Set<String> alreadyAdded, List<String> result) {
        for (BaseUnit reference : references) {
            String id = reference.id();
            if (alreadyAdded.contains(id)) continue;
            String location = reference.location();
            result.add(location);
            alreadyAdded.add(id);
            this.appendReferences(reference.references(), alreadyAdded, result);
        }
    }

    public WebApi getWebApi() {
        return this.webApi.get();
    }

    public ApiValidationReport validate() {
        ValidationReport validationReport = this.parser.getParsingReport(this.document.get());
        List<Object> results = new ArrayList(0);
        if (!validationReport.conforms()) {
            results = validationReport.results().stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
        }
        return new DefaultApiValidationReport(results);
    }

    public ApiSpecification parse() {
        AMFParserWrapper parserWrapper = AMFParserWrapperFactory.getParser(this.apiRef, this.executionEnvironment);
        return new AMFImpl(this.webApi.get(), this.getReferences(this.document.get().references()), parserWrapper, this.apiRef.getVendor(), this.apiRef.getLocation(), this.apiUri);
    }

    private void initAMF() {
        try {
            if (this.executionEnvironment != null) {
                amf.client.AMF.init((BaseExecutionEnvironment)this.executionEnvironment).get();
            } else {
                amf.client.AMF.init().get();
            }
            AMF.registerPlugin((AMFPlugin)new XmlValidationPlugin());
        }
        catch (Exception e) {
            logger.error("Error initializing AMF", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

