/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.DataNode;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.ScalarNode;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import amf.client.validate.ValidationResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.amf.impl.exceptions.UnsupportedSchemaException;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ScalarType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.model.MetadataType;

class ParameterImpl
implements Parameter {
    private AnyShape schema;
    private boolean required;
    private Set<String> scalarTypes;
    private final Map<String, PayloadValidator> payloadValidatorMap = new HashMap<String, PayloadValidator>();
    private final String defaultMediaType = "application/yaml";

    ParameterImpl(amf.client.model.domain.Parameter parameter) {
        this(ParameterImpl.getSchema(parameter), parameter.required().value());
    }

    ParameterImpl(PropertyShape property) {
        this(ParameterImpl.castToAnyShape(property.range()), property.minCount().value() > 0);
    }

    ParameterImpl(AnyShape anyShape, boolean required) {
        this.schema = anyShape;
        this.required = required;
        List<ScalarType> typeIds = Arrays.asList(ScalarType.values());
        this.scalarTypes = typeIds.stream().map(ScalarType::getName).collect(Collectors.toSet());
    }

    public boolean validate(String value) {
        return this.validatePayload(value).conforms();
    }

    private ValidationReport validatePayload(String value) {
        String mimeType = MediaType.getMimeTypeForValue(value);
        PayloadValidator payloadValidator = this.resolvePayloadValidator(mimeType, value);
        try {
            return (ValidationReport)payloadValidator.validate(mimeType, value != null ? value : "null").get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unexpected Error validating request", e);
        }
    }

    private PayloadValidator resolvePayloadValidator(String mimeType, String value) {
        if (value == null) {
            return (PayloadValidator)this.schema.payloadValidator(mimeType).get();
        }
        if (this.payloadValidatorMap.containsKey(mimeType)) {
            return this.payloadValidatorMap.get(mimeType);
        }
        Optional payloadValidator = this.schema.parameterValidator(mimeType);
        if (payloadValidator.isPresent()) {
            this.payloadValidatorMap.put(mimeType, (PayloadValidator)payloadValidator.get());
            return (PayloadValidator)payloadValidator.get();
        }
        payloadValidator = this.schema.parameterValidator("application/yaml");
        if (payloadValidator.isPresent()) {
            this.payloadValidatorMap.put(mimeType, (PayloadValidator)payloadValidator.get());
            return (PayloadValidator)payloadValidator.get();
        }
        throw new RuntimeException("Unexpected Error validating request");
    }

    private static AnyShape getSchema(amf.client.model.domain.Parameter parameter) {
        Shape shape = parameter.schema();
        return ParameterImpl.castToAnyShape(shape);
    }

    private static AnyShape castToAnyShape(Shape shape) {
        if (shape instanceof AnyShape) {
            return (AnyShape)shape;
        }
        throw new UnsupportedSchemaException();
    }

    public String message(String value) {
        ValidationReport validationReport = this.validatePayload(value);
        if (validationReport.conforms()) {
            return "OK";
        }
        return validationReport.results().stream().findFirst().map(ValidationResult::message).orElse("Error");
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        DataNode defaultValue = this.schema.defaultValue();
        if (defaultValue instanceof ScalarNode) {
            return ((ScalarNode)defaultValue).value().value();
        }
        return this.schema.defaultValueStr().option().orElse(null);
    }

    public boolean isRepeat() {
        return this.schema instanceof ArrayShape;
    }

    public boolean isArray() {
        return this.schema instanceof ArrayShape;
    }

    public String getDisplayName() {
        return this.schema.displayName().value();
    }

    public String getDescription() {
        return this.schema.description().value();
    }

    public String getExample() {
        return this.schema.examples().stream().filter(example -> example.name().value() == null).map(example -> example.value().value()).findFirst().orElse(null);
    }

    public Map<String, String> getExamples() {
        return this.schema.examples().stream().filter(example -> example.name().value() != null).collect(Collectors.toMap(e -> e.name().value(), e -> e.value().value()));
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public MetadataType getMetadata() {
        throw new UnsupportedOperationException();
    }

    public boolean isScalar() {
        return this.scalarTypes.contains(this.schema.id());
    }

    public boolean isFacetArray(String facet) {
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                if (!facet.equals(type.name().value())) continue;
                return type.range() instanceof ArrayShape;
            }
        }
        return false;
    }

    public String surroundWithQuotesIfNeeded(String value) {
        if (value != null && (value.startsWith("*") || this.isStringArray())) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private boolean isStringArray() {
        if (!(this.schema instanceof ArrayShape)) {
            return false;
        }
        Shape items = ((ArrayShape)this.schema).items();
        if (!(items instanceof ScalarShape)) {
            return false;
        }
        return ((ScalarShape)items).dataType().value().equals("http://www.w3.org/2001/XMLSchema#string");
    }
}

