/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.UnionShape;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.mule.amf.impl.model.JsonParameterValidationStrategy;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.model.YamlParameterValidationStrategy;

class ParameterValidationStrategyFactory {
    private static final Set<String> NOT_QUOTABLE_DATA_TYPES = ImmutableSet.of((Object)"integer", (Object)"float", (Object)"number", (Object)"boolean");

    private ParameterValidationStrategyFactory() {
        throw new IllegalStateException("Utility class");
    }

    static ParameterValidationStrategy getStrategy(AnyShape anyShape) {
        if (anyShape instanceof ArrayShape || anyShape instanceof UnionShape) {
            return new YamlParameterValidationStrategy(anyShape);
        }
        return new JsonParameterValidationStrategy(anyShape, ParameterValidationStrategyFactory.needsQuotes(anyShape));
    }

    private static boolean needsQuotes(AnyShape anyShape) {
        if (!(anyShape instanceof ScalarShape)) {
            return false;
        }
        String dataType = ((ScalarShape)anyShape).dataType().value();
        return !NOT_QUOTABLE_DATA_TYPES.contains(dataType = dataType.substring(dataType.lastIndexOf(35) + 1));
    }
}

