/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl;

import amf.ProfileName;
import amf.ProfileNames;
import amf.client.AMF;
import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.WebApi;
import amf.client.parse.Parser;
import amf.client.resolve.Raml10Resolver;
import amf.client.validate.ValidationReport;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.amf.impl.AMFUtils;
import org.mule.amf.impl.DocumentParser;
import org.mule.amf.impl.loader.ExchangeDependencyResourceLoader;
import org.mule.amf.impl.loader.ProvidedResourceLoader;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.amf.impl.parser.rule.ApiValidationResultImpl;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ApiParser;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.apikit.validation.DefaultApiValidationReport;

public class AMFParser
implements ApiParser {
    private final ApiReference apiRef;
    private final Parser parser;
    private final WebApi webApi;
    private final List<String> references;
    private Document consoleModel;

    public AMFParser(ApiReference apiRef, boolean validate) throws ExecutionException, InterruptedException {
        AMF.init().get();
        this.apiRef = apiRef;
        this.parser = this.initParser(apiRef);
        Document document = this.buildDocument(validate);
        this.references = this.getReferences(document.references());
        this.webApi = DocumentParser.getWebApi((BaseUnit)document);
    }

    private Parser initParser(ApiReference apiRef) {
        Environment environment = this.buildEnvironment(apiRef);
        return DocumentParser.getParserForApi(apiRef, environment);
    }

    private List<String> getReferences(List<BaseUnit> references) {
        ArrayList<String> result = new ArrayList<String>();
        this.appendReferences(references, new HashSet<String>(), result);
        return result;
    }

    private void appendReferences(List<BaseUnit> references, Set<String> alreadyAdded, List<String> result) {
        for (BaseUnit reference : references) {
            String id = reference.id();
            if (alreadyAdded.contains(id)) continue;
            String location = reference.location();
            result.add(location);
            alreadyAdded.add(id);
            this.appendReferences(reference.references(), alreadyAdded, result);
        }
    }

    private Environment buildEnvironment(ApiReference apiRef) {
        URI uri = AMFUtils.getPathAsUri(apiRef);
        Environment environment = DefaultEnvironment.apply();
        if (uri.getScheme() != null && uri.getScheme().startsWith("file")) {
            File file = new File(uri);
            String rootDir = file.isDirectory() ? file.getPath() : file.getParent();
            environment = environment.add((amf.client.resource.ResourceLoader)new ExchangeDependencyResourceLoader(rootDir));
        }
        if (apiRef.getResourceLoader().isPresent()) {
            environment = environment.add((amf.client.resource.ResourceLoader)new ProvidedResourceLoader((ResourceLoader)apiRef.getResourceLoader().get()));
        }
        return environment;
    }

    public WebApi getWebApi() {
        return this.webApi;
    }

    public ApiValidationReport validate() {
        ValidationReport validationReport = this.generateValidationReport();
        List<Object> results = new ArrayList(0);
        if (!validationReport.conforms()) {
            results = validationReport.results().stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
        }
        return new DefaultApiValidationReport(results);
    }

    private ValidationReport generateValidationReport() {
        ValidationReport validationReport;
        try {
            validationReport = (ValidationReport)this.parser.reportValidation(this.apiVendorToProfileName(this.apiRef.getVendor())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unexpected error parsing API: " + e.getMessage(), e);
        }
        return validationReport;
    }

    private ProfileName apiVendorToProfileName(ApiVendor apiVendor) {
        switch (apiVendor) {
            case OAS: {
                return ProfileNames.OAS();
            }
            case OAS_20: {
                return ProfileNames.OAS20();
            }
            case RAML: {
                return ProfileNames.RAML();
            }
            case RAML_08: {
                return ProfileNames.RAML08();
            }
            case RAML_10: {
                return ProfileNames.RAML10();
            }
        }
        return ProfileNames.AMF();
    }

    public ApiSpecification parse() {
        return new AMFImpl(this.webApi, this.references, this.apiRef.getVendor(), new LazyValue<Document>(this::getConsoleModel), this.apiRef);
    }

    private Document getConsoleModel() {
        if (this.consoleModel == null) {
            Document document = this.buildDocument(false);
            this.consoleModel = (Document)new Raml10Resolver().resolve((BaseUnit)document, "editing");
        }
        return this.consoleModel;
    }

    private Document buildDocument(boolean validate) {
        URI uri = AMFUtils.getPathAsUri(this.apiRef);
        return DocumentParser.parseFile(this.parser, uri, validate);
    }
}

