/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.mule.apikit.model.api.ApiReference;

public class AMFUtils {
    public static URI getPathAsUri(ApiReference apiRef) {
        try {
            URI uri = new URI(apiRef.getLocation());
            return uri.isAbsolute() ? uri : AMFUtils.getUriFromFile(apiRef);
        }
        catch (URISyntaxException e) {
            return AMFUtils.getUriFromFile(apiRef);
        }
    }

    private static URI getUriFromFile(ApiReference apiRef) {
        URI uri;
        String location = apiRef.getLocation();
        if (apiRef.getResourceLoader().isPresent() && (uri = (URI)apiRef.getResourceLoader().map(loader -> loader.getResource(location)).orElse(null)) != null) {
            return uri;
        }
        File file = new File(location);
        if (file.exists()) {
            return file.toURI();
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
        if (resource != null) {
            try {
                return resource.toURI();
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException("Couldn't load api in location: " + location);
            }
        }
        throw new RuntimeException("Couldn't load api in location: " + location);
    }
}

