/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.amf.impl.model.ActionImpl;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.parameter.Parameter;

public class ResourceImpl
implements Resource {
    private AMFImpl amf;
    private EndPoint endPoint;
    private Map<ActionType, Action> actions;
    private Map<String, Parameter> resolvedUriParameters;

    ResourceImpl(AMFImpl amf, EndPoint endPoint) {
        this.amf = amf;
        this.endPoint = endPoint;
    }

    public String getRelativeUri() {
        return this.endPoint.relativePath();
    }

    public String getUri() {
        return this.endPoint.path().value();
    }

    public String getResolvedUri(String version) {
        return ParserUtils.resolveVersion((String)this.getUri(), (String)version);
    }

    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    public Action getAction(String name) {
        return this.getActions().get(ResourceImpl.getActionKey(name));
    }

    public Map<ActionType, Action> getActions() {
        if (this.actions == null) {
            this.actions = this.loadActions(this.endPoint);
        }
        return this.actions;
    }

    private Map<ActionType, Action> loadActions(EndPoint endPoint) {
        LinkedHashMap<ActionType, Action> map = new LinkedHashMap<ActionType, Action>();
        endPoint.operations().forEach(operation -> {
            Action cfr_ignored_0 = map.put(ResourceImpl.getActionKey(operation.method().value()), new ActionImpl(this, (Operation)operation));
        });
        return map;
    }

    private static ActionType getActionKey(String method) {
        return ActionType.valueOf((String)method.toUpperCase());
    }

    public Map<String, Resource> getResources() {
        return this.amf.getResources(this);
    }

    public String getDisplayName() {
        String value = this.endPoint.name().value();
        return value != null ? value : this.getRelativeUri();
    }

    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.endPoint);
        }
        return this.resolvedUriParameters;
    }

    private static Map<String, Parameter> loadResolvedUriParameters(EndPoint resource) {
        return resource.parameters().stream().filter(p -> !"version".equals(p.name().value())).collect(Collectors.toMap(p -> p.name().value(), ParameterImpl::new));
    }

    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getUri();
    }
}

