/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.Example;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.Payload;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.parser.rule.ApiValidationResultImpl;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.apikit.validation.ExceptionApiValidationResult;

public class MimeTypeImpl
implements MimeType {
    private final Payload payload;
    private final Shape shape;
    private final Map<String, PayloadValidator> payloadValidatorMap = new HashMap<String, PayloadValidator>();
    private final String defaultMediaType;
    private Map<String, List<Parameter>> formParameters;

    public MimeTypeImpl(Payload payload) {
        this.payload = payload;
        this.shape = payload.schema();
        this.defaultMediaType = this.payload.mediaType().option().orElse(null);
    }

    public Object getCompiledSchema() {
        return null;
    }

    public String getSchema() {
        if (this.shape.getClass() == AnyShape.class) {
            return null;
        }
        if (this.shape instanceof AnyShape) {
            return ((AnyShape)this.shape).buildJsonSchema();
        }
        return null;
    }

    public Map<String, List<Parameter>> getFormParameters() {
        if (MapUtils.isNotEmpty(this.formParameters)) {
            return this.formParameters;
        }
        String mediaType = this.payload.mediaType().value();
        if (mediaType.startsWith("multipart/") || mediaType.equals("application/x-www-form-urlencoded")) {
            if (!(this.shape instanceof NodeShape)) {
                return Collections.emptyMap();
            }
            NodeShape nodeShape = (NodeShape)this.shape;
            Map<String, Set<String>> formParametersEncoding = this.getFormParametersEncoding();
            this.formParameters = new LinkedHashMap<String, List<Parameter>>();
            for (PropertyShape propertyShape : nodeShape.properties()) {
                String propertyName = propertyShape.name().value();
                this.formParameters.put(propertyName, Collections.singletonList(new ParameterImpl(propertyShape, formParametersEncoding.get(propertyName))));
            }
            return this.formParameters;
        }
        return Collections.emptyMap();
    }

    public String getType() {
        return this.payload.mediaType().value();
    }

    public String getExample() {
        List examplesList;
        if (this.shape instanceof UnionShape) {
            UnionShape unionShape = (UnionShape)this.shape;
            for (Shape shape : unionShape.anyOf()) {
                String example;
                if (!(shape instanceof AnyShape) || (example = this.getExampleFromAnyShape((AnyShape)shape)) == null) continue;
                return example;
            }
        }
        if (this.shape instanceof AnyShape) {
            return this.getExampleFromAnyShape((AnyShape)this.shape);
        }
        if (this.shape == null && CollectionUtils.isNotEmpty((Collection)(examplesList = this.payload.examples()))) {
            return this.getExampleValueByMediaType((Example)examplesList.get(0));
        }
        return null;
    }

    private String getExampleFromAnyShape(AnyShape anyShape) {
        Example example2;
        Optional trackedExample = anyShape.trackedExample(this.payload.id());
        if (trackedExample.isPresent() && (example2 = (Example)trackedExample.get()).value().nonNull()) {
            return this.getExampleValueByMediaType(example2);
        }
        return anyShape.examples().stream().filter(example -> example.value().value() != null).map(example -> this.getExampleValueByMediaType((Example)example)).findFirst().orElse(null);
    }

    private String getExampleValueByMediaType(Example example) {
        String mimeType;
        switch (mimeType = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getType(), this.defaultMediaType})) {
            case "application/json": {
                return example.toJson();
            }
            case "application/yaml": {
                return example.toYaml();
            }
        }
        return example.value().value();
    }

    public Object getInstance() {
        return null;
    }

    public List<ApiValidationResult> validate(String payload) {
        String mimeType = MediaType.getMimeTypeForValue(payload);
        PayloadValidator payloadValidator = this.payloadValidatorMap.computeIfAbsent(mimeType, payloadMimeType -> this.getPayloadValidator((String)payloadMimeType).orElse(null));
        if (payloadValidator != null) {
            return MimeTypeImpl.mapToValidationResult(payloadValidator.syncValidate(mimeType, payload));
        }
        return ImmutableList.of((Object)new ExceptionApiValidationResult((Exception)new RuntimeException(String.format("Validator not found for %s", mimeType))));
    }

    private Optional<PayloadValidator> getPayloadValidator(String mediaType) {
        return ((AnyShape)this.shape).payloadValidator(mediaType);
    }

    private static List<ApiValidationResult> mapToValidationResult(ValidationReport validationReport) {
        if (validationReport.conforms()) {
            return Collections.emptyList();
        }
        return validationReport.results().stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
    }

    private Map<String, Set<String>> getFormParametersEncoding() {
        LinkedHashMap<String, Set<String>> formParametersEncoding = new LinkedHashMap<String, Set<String>>();
        List encodingList = this.payload.encoding();
        if (CollectionUtils.isNotEmpty((Collection)encodingList)) {
            encodingList.forEach(e -> formParametersEncoding.put(e.propertyName().value(), this.getContentTypeSet(e.contentType().value())));
        }
        return formParametersEncoding;
    }

    private Set<String> getContentTypeSet(String contentTypeCSV) {
        String[] contentTypes = contentTypeCSV.split(",");
        HashSet<String> contentTypeSet = new HashSet<String>();
        for (String contentType : contentTypes) {
            contentTypeSet.add(contentType.trim());
        }
        return contentTypeSet;
    }
}

