/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.UnionShape;
import amf.client.model.domain.ValidatorAware;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.mule.amf.impl.model.JsonParameterValidationStrategy;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.model.YamlParameterValidationStrategy;

class ParameterValidationStrategyFactory {
    private ParameterValidationStrategyFactory() {
        throw new IllegalStateException("Utility class");
    }

    static ParameterValidationStrategy getStrategy(AnyShape anyShape, boolean needsCharEscaping) {
        return ParameterValidationStrategyFactory.isYamlValidationNeeded(anyShape) ? new YamlParameterValidationStrategy(anyShape) : ParameterValidationStrategyFactory.getJsonParameterValidationStrategy(anyShape, needsCharEscaping);
    }

    private static JsonParameterValidationStrategy getJsonParameterValidationStrategy(AnyShape anyShape, boolean needsCharsEscaping) {
        return new JsonParameterValidationStrategy((ValidatorAware)anyShape, needsCharsEscaping);
    }

    private static boolean isYamlValidationNeeded(AnyShape anyShape) {
        return anyShape instanceof ArrayShape || anyShape instanceof UnionShape || CollectionUtils.isNotEmpty((Collection)anyShape.or()) || CollectionUtils.isNotEmpty((Collection)anyShape.and()) || CollectionUtils.isNotEmpty((Collection)anyShape.xone()) || anyShape.not() != null;
    }
}

