/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.ValidatorAware;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import org.json.simple.JSONValue;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.util.LazyValue;

class JsonParameterValidationStrategy
implements ParameterValidationStrategy {
    private final boolean needsCharsEscaping;
    private ValidatorAware validatorAware;
    private final LazyValue<PayloadValidator> jsonValidator = new LazyValue<PayloadValidator>(() -> (PayloadValidator)this.validatorAware.payloadValidator("application/json").orElseThrow(() -> new ParserException("application/json validator not found for shape " + this.validatorAware)));
    private final LazyValue<ValidationReport> nullValidationReport = new LazyValue<ValidationReport>(() -> {
        PayloadValidator yamlPayloadValidator = (PayloadValidator)this.validatorAware.payloadValidator("application/yaml").orElseThrow(() -> new ParserException("application/yaml validator not found for shape " + this.validatorAware));
        return yamlPayloadValidator.syncValidate("application/yaml", "null");
    });

    JsonParameterValidationStrategy(ValidatorAware validatorAware, boolean needsCharsEscaping) {
        this.validatorAware = validatorAware;
        this.needsCharsEscaping = needsCharsEscaping;
    }

    @Override
    public ValidationReport validate(String value) {
        if (value == null) {
            return this.nullValidationReport.get();
        }
        return this.jsonValidator.get().syncValidate("application/json", this.getPayload(value));
    }

    private String getPayload(String value) {
        if (this.needsCharsEscaping && value.startsWith("\"")) {
            return ParameterImpl.quote(JSONValue.escape((String)value.substring(1, value.length() - 1)));
        }
        return this.removeLeadingZeros(value);
    }

    private String removeLeadingZeros(String value) {
        if (!value.startsWith("0")) {
            return value;
        }
        int indexOfLastLeadingZero = 0;
        while (indexOfLastLeadingZero + 1 < value.length()) {
            char next = value.charAt(indexOfLastLeadingZero);
            if (next == '.') {
                --indexOfLastLeadingZero;
                break;
            }
            if (next != '0') break;
            ++indexOfLastLeadingZero;
        }
        return value.substring(indexOfLastLeadingZero);
    }
}

