/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Payload;
import amf.client.model.domain.Request;
import amf.client.model.domain.Shape;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.MimeTypeImpl;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.QueryStringImpl;
import org.mule.amf.impl.model.ResourceImpl;
import org.mule.amf.impl.model.ResponseImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.SecurityReference;
import org.mule.apikit.model.parameter.Parameter;

public class ActionImpl
implements Action {
    private static final String VERSION = "version";
    private final ResourceImpl resource;
    private final Operation operation;
    private Map<String, MimeType> bodies;
    private Map<String, Response> responses;
    private Map<String, Parameter> queryParameters;
    private Map<String, Parameter> headers;
    private Map<String, Parameter> resolvedUriParameters;
    private QueryString queryString;
    private String successStatusCode;

    public ActionImpl(ResourceImpl resource, Operation operation) {
        this.resource = resource;
        this.operation = operation;
        this.queryString = this.initializeQueryString(operation);
    }

    public ActionType getType() {
        return ActionType.valueOf((String)this.operation.method().value().toUpperCase());
    }

    public boolean hasBody() {
        return !this.getBody().isEmpty();
    }

    public Map<String, Response> getResponses() {
        if (this.responses == null) {
            this.responses = ActionImpl.loadResponses(this.operation);
        }
        return this.responses;
    }

    private static Map<String, Response> loadResponses(Operation operation) {
        LinkedHashMap<String, Response> result = new LinkedHashMap<String, Response>();
        for (amf.client.model.domain.Response response : operation.responses()) {
            result.put(response.statusCode().value(), new ResponseImpl(response));
        }
        return result;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, MimeType> getBody() {
        if (this.bodies == null) {
            this.bodies = ActionImpl.loadBodies(this.operation);
        }
        return this.bodies;
    }

    private static Map<String, MimeType> loadBodies(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, MimeType> result = new LinkedHashMap<String, MimeType>();
        request.payloads().stream().filter(payload -> payload.mediaType().nonNull()).forEach(payload -> {
            MimeType cfr_ignored_0 = result.put(payload.mediaType().value(), new MimeTypeImpl((Payload)payload));
        });
        return result;
    }

    public Map<String, Parameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = ActionImpl.loadQueryParameters(this.operation);
        }
        return this.queryParameters;
    }

    private static Map<String, Parameter> loadQueryParameters(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        request.queryParameters().forEach(parameter -> result.put(parameter.name().value(), new ParameterImpl((amf.client.model.domain.Parameter)parameter)));
        return result;
    }

    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ActionImpl.loadResolvedUriParameters(this.resource, this.operation);
        }
        return this.resolvedUriParameters;
    }

    private static Map<String, Parameter> loadResolvedUriParameters(Resource resource, Operation operation) {
        Map<String, Parameter> operationUriParams = new HashMap<String, Parameter>();
        if (operation.request() != null) {
            List collectedUriParams = operation.request().uriParameters().stream().filter(p -> !VERSION.equals(p.name().value())).collect(Collectors.toList());
            operationUriParams = collectedUriParams.stream().collect(Collectors.toMap(p -> p.name().value(), ParameterImpl::new, (p1, p2) -> p2));
        }
        Map uriParameters = resource.getResolvedUriParameters();
        uriParameters.forEach(operationUriParams::putIfAbsent);
        return operationUriParams;
    }

    public Map<String, Parameter> getHeaders() {
        if (this.headers == null) {
            this.headers = this.loadHeaders(this.operation);
        }
        return this.headers;
    }

    private Map<String, Parameter> loadHeaders(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        request.headers().forEach(parameter -> result.put(parameter.name().value(), new ParameterImpl((amf.client.model.domain.Parameter)parameter)));
        return result;
    }

    public List<SecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, Parameter> headers) {
        throw new UnsupportedOperationException();
    }

    public void setQueryParameters(Map<String, Parameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    public void setBody(Map<String, MimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void addResponse(String key, Response response) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }

    public QueryString queryString() {
        return this.queryString;
    }

    public String getSuccessStatusCode() {
        if (this.successStatusCode == null) {
            this.successStatusCode = super.getSuccessStatusCode();
        }
        return this.successStatusCode;
    }

    private QueryString initializeQueryString(Operation op) {
        Request request = op.request();
        Shape shape = request != null ? request.queryString() : null;
        return shape != null ? new QueryStringImpl((AnyShape)shape) : null;
    }
}

