/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.rule;

import amf.client.validate.ValidationResult;
import amf.core.parser.Position;
import amf.core.parser.Range;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.apikit.validation.Severity;

public class ApiValidationResultImpl
implements ApiValidationResult {
    private static final String ERROR_FORMAT = "%s\n  Location: %s\n  Position: %s";
    private static final String POSITION_FORMAT = "Line %s,  Column %s";
    private ValidationResult validationResult;
    private List<String> severities;

    public ApiValidationResultImpl(ValidationResult validationResult) {
        this.validationResult = validationResult;
        this.severities = Arrays.stream(Severity.values()).map(Enum::name).collect(Collectors.toList());
    }

    public String getMessage() {
        Optional location = this.validationResult.location();
        Range positionRange = this.validationResult.position();
        if (location.isPresent() && !positionRange.start().isZero()) {
            return String.format(ERROR_FORMAT, this.validationResult.message(), URLDecoder.decode((String)location.get()), ApiValidationResultImpl.getPositionMessage(positionRange.start()));
        }
        return this.validationResult.message();
    }

    public Optional<Integer> getLine() {
        return Optional.empty();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public Severity getSeverity() {
        return !this.severities.contains(this.validationResult.level().toUpperCase()) ? Severity.ERROR : Severity.fromString((String)this.validationResult.level());
    }

    private static String getPositionMessage(Position startPosition) {
        return String.format(POSITION_FORMAT, startPosition.line(), startPosition.column());
    }

    public String toString() {
        return this.getMessage();
    }
}

