/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.ValidatorAware;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import org.json.simple.JSONValue;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.model.ValidationStrategy;
import org.mule.amf.impl.util.LazyValue;

class JsonParameterValidationStrategy
extends ValidationStrategy {
    private final LazyValue<PayloadValidator> jsonValidator = new LazyValue<PayloadValidator>(() -> (PayloadValidator)this.schema.payloadValidator("application/json").orElseThrow(() -> new ParserException("application/json validator not found for shape " + this.schema)));
    private final LazyValue<ValidationReport> nullValidationReport = new LazyValue<ValidationReport>(() -> {
        PayloadValidator yamlPayloadValidator = (PayloadValidator)this.schema.payloadValidator("application/yaml").orElseThrow(() -> new ParserException("application/yaml validator not found for shape " + this.schema));
        return yamlPayloadValidator.syncValidate("application/yaml", "null");
    });

    public JsonParameterValidationStrategy(ValidatorAware validatorAware, boolean schemaNeedsQuotes) {
        super(validatorAware, schemaNeedsQuotes);
    }

    @Override
    public boolean valueNeedQuotes(String value) {
        return this.schemaNeedsQuotes;
    }

    @Override
    public boolean needsPreProcess(String value) {
        return true;
    }

    @Override
    public ValidationReport validate(String value) {
        if (value == null) {
            return this.nullValidationReport.get();
        }
        return this.jsonValidator.get().syncValidate("application/json", value);
    }

    @Override
    public String escapeCharsInValue(String value) {
        return JSONValue.escape((String)value);
    }

    @Override
    public String removeLeadingZeros(String value) {
        if (value == null || !value.startsWith("0")) {
            return value;
        }
        int indexOfLastLeadingZero = 0;
        while (indexOfLastLeadingZero + 1 < value.length()) {
            char next = value.charAt(indexOfLastLeadingZero);
            if (next == '.') {
                --indexOfLastLeadingZero;
                break;
            }
            if (next != '0') break;
            ++indexOfLastLeadingZero;
        }
        return value.substring(indexOfLastLeadingZero);
    }
}

