/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFElementClient;
import amf.core.client.common.validation.ValidationMode;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import amf.shapes.client.platform.model.domain.AnyShape;
import org.json.simple.JSONValue;
import org.mule.amf.impl.model.ValidationStrategy;
import org.mule.amf.impl.util.LazyValue;

class JsonParameterValidationStrategy
extends ValidationStrategy {
    private LazyValue<AMFShapePayloadValidator> jsonValidator = new LazyValue<AMFShapePayloadValidator>(() -> client.payloadValidatorFor((Shape)anyShape, "application/json", ValidationMode.StrictValidationMode()));
    private LazyValue<AMFValidationReport> nullValidationReport = new LazyValue<AMFValidationReport>(() -> {
        AMFShapePayloadValidator yamlPayloadValidator = client.payloadValidatorFor((Shape)anyShape, "application/yaml", ValidationMode.StrictValidationMode());
        return yamlPayloadValidator.syncValidate("null");
    });

    public JsonParameterValidationStrategy(AMFElementClient client, AnyShape anyShape, boolean schemaNeedsQuotes) {
        super(schemaNeedsQuotes);
    }

    @Override
    public boolean valueNeedQuotes(String value) {
        return this.schemaNeedsQuotes;
    }

    @Override
    public boolean needsPreProcess(String value) {
        return true;
    }

    @Override
    public AMFValidationReport validate(String value) {
        if (value == null) {
            return this.nullValidationReport.get();
        }
        return this.jsonValidator.get().syncValidate(value);
    }

    @Override
    public String escapeCharsInValue(String value) {
        return JSONValue.escape((String)value);
    }

    @Override
    public String removeLeadingZeros(String value) {
        if (value == null || !value.startsWith("0")) {
            return value;
        }
        int indexOfLastLeadingZero = 0;
        while (indexOfLastLeadingZero + 1 < value.length()) {
            char next = value.charAt(indexOfLastLeadingZero);
            if (next == '.') {
                --indexOfLastLeadingZero;
                break;
            }
            if (next != '0') break;
            ++indexOfLastLeadingZero;
        }
        return value.substring(indexOfLastLeadingZero);
    }
}

