/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.loader;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.resource.FileResourceLoader;
import amf.core.client.platform.resource.ResourceLoader;
import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExchangeDependencyResourceLoader
implements ResourceLoader {
    private final File workingDir;
    private final FileResourceLoader resourceLoader;
    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public ExchangeDependencyResourceLoader(String rootDir, ExecutionEnvironment executionEnvironment) {
        String basePath = rootDir != null ? rootDir : ".";
        this.workingDir = new File(basePath);
        this.resourceLoader = new FileResourceLoader((BaseExecutionEnvironment)executionEnvironment);
    }

    public CompletableFuture<Content> fetch(String path) {
        CompletableFuture<Content> future = new CompletableFuture<Content>();
        if (path == null || path.isEmpty()) {
            future.completeExceptionally(new Exception("Failed to apply."));
            return future;
        }
        Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
        if (matcher.find()) {
            int dependencyIndex = path.lastIndexOf(matcher.group(0));
            String resourceName = dependencyIndex <= 0 ? path : path.substring(dependencyIndex);
            return this.resourceLoader.fetch(Paths.get(this.workingDir.getPath(), resourceName).toUri().toString());
        }
        return this.resourceLoader.fetch(path);
    }
}

