/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.Request;
import amf.apicontract.client.platform.model.domain.Response;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.MimeTypeImpl;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.QueryStringImpl;
import org.mule.amf.impl.model.ResourceImpl;
import org.mule.amf.impl.model.ResponseImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.SecurityReference;
import org.mule.apikit.model.parameter.Parameter;

public class ActionImpl
implements Action {
    private static final String VERSION = "version";
    private static final Predicate<amf.apicontract.client.platform.model.domain.Parameter> IS_NOT_VERSION = p -> !VERSION.equals(p.parameterName().value());
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    private final ResourceImpl resource;
    private final Operation operation;
    private Map<String, MimeType> bodies;
    private Map<String, org.mule.apikit.model.Response> responses;
    private Map<String, Parameter> queryParameters;
    private Map<String, Parameter> headers;
    private Map<String, Parameter> resolvedUriParameters;
    private QueryString queryString;
    private String successStatusCode;

    public ActionImpl(ResourceImpl resource, Operation operation) {
        this.resource = resource;
        this.operation = operation;
        this.queryString = this.initializeQueryString(operation);
    }

    public ActionType getType() {
        return ActionType.valueOf((String)this.operation.method().value().toUpperCase());
    }

    public boolean hasBody() {
        return !this.getBody().isEmpty();
    }

    public Map<String, org.mule.apikit.model.Response> getResponses() {
        if (this.responses == null) {
            this.responses = ActionImpl.loadResponses(this.operation, this.resource.getAmfConfiguration());
        }
        return this.responses;
    }

    private static Map<String, org.mule.apikit.model.Response> loadResponses(Operation operation, AMFConfiguration amfConfiguration) {
        LinkedHashMap<String, org.mule.apikit.model.Response> result = new LinkedHashMap<String, org.mule.apikit.model.Response>();
        for (Response response : operation.responses()) {
            result.put(response.statusCode().value(), new ResponseImpl(response, amfConfiguration));
        }
        return result;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, MimeType> getBody() {
        if (this.bodies == null) {
            this.bodies = ActionImpl.loadBodies(this.operation, this.resource.getAmfConfiguration());
        }
        return this.bodies;
    }

    private static Map<String, MimeType> loadBodies(Operation operation, AMFConfiguration amfConfiguration) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, MimeType> result = new LinkedHashMap<String, MimeType>();
        request.payloads().stream().filter(payload -> payload.schema() != null).forEach(payload -> ActionImpl.addMimeTypes(result, payload, amfConfiguration));
        return result;
    }

    private static void addMimeTypes(Map<String, MimeType> result, Payload payload, AMFConfiguration amfConfiguration) {
        if (payload.mediaType().nonNull()) {
            result.put(payload.mediaType().value(), new MimeTypeImpl(payload, amfConfiguration));
        } else {
            result.put(APPLICATION_JSON, new MimeTypeImpl(payload, amfConfiguration));
            result.put(APPLICATION_XML, new MimeTypeImpl(payload, amfConfiguration));
        }
    }

    public Map<String, Parameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = ActionImpl.loadQueryParameters(this.operation, this.resource.getAmfConfiguration());
        }
        return this.queryParameters;
    }

    private static Map<String, Parameter> loadQueryParameters(Operation operation, AMFConfiguration amfConfiguration) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        request.queryParameters().forEach(parameter -> result.put(parameter.parameterName().value(), new ParameterImpl((amf.apicontract.client.platform.model.domain.Parameter)parameter, amfConfiguration)));
        return result;
    }

    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ActionImpl.loadResolvedUriParameters(this.resource, this.operation);
        }
        return this.resolvedUriParameters;
    }

    private static Map<String, Parameter> loadResolvedUriParameters(Resource resource, Operation operation) {
        Map<String, Parameter> operationUriParams = new HashMap<String, Parameter>();
        if (operation.request() != null) {
            List collectedUriParams = operation.request().uriParameters().stream().filter(IS_NOT_VERSION).collect(Collectors.toList());
            operationUriParams = collectedUriParams.stream().collect(Collectors.toMap(p -> p.parameterName().value(), p -> new ParameterImpl((amf.apicontract.client.platform.model.domain.Parameter)p, ((ResourceImpl)resource).getAmfConfiguration()), (p1, p2) -> p2));
        }
        Map uriParameters = resource.getResolvedUriParameters();
        uriParameters.forEach(operationUriParams::putIfAbsent);
        return operationUriParams;
    }

    public Map<String, Parameter> getHeaders() {
        if (this.headers == null) {
            this.headers = this.loadHeaders(this.operation);
        }
        return this.headers;
    }

    private Map<String, Parameter> loadHeaders(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        request.headers().forEach(parameter -> result.put(parameter.parameterName().value(), new ParameterImpl((amf.apicontract.client.platform.model.domain.Parameter)parameter, this.resource.getAmfConfiguration())));
        return result;
    }

    public List<SecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, Parameter> headers) {
        throw new UnsupportedOperationException();
    }

    public void setQueryParameters(Map<String, Parameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    public void setBody(Map<String, MimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void addResponse(String key, org.mule.apikit.model.Response response) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }

    public QueryString queryString() {
        return this.queryString;
    }

    public String getSuccessStatusCode() {
        if (this.successStatusCode == null) {
            this.successStatusCode = super.getSuccessStatusCode();
        }
        return this.successStatusCode;
    }

    private QueryString initializeQueryString(Operation op) {
        Request request = op.request();
        Shape shape = request != null ? request.queryString() : null;
        return shape != null ? new QueryStringImpl((AnyShape)shape, this.resource.getAmfConfiguration()) : null;
    }
}

